# nf-core/readsimulator: Citations

## [nf-core](https://pubmed.ncbi.nlm.nih.gov/32055031/)

> Ewels PA, Peltzer A, Fillinger S, Patel H, Alneberg J, Wilm A, Garcia MU, Di Tommaso P, Nahnsen S. The nf-core framework for community-curated bioinformatics pipelines. Nat Biotechnol. 2020 Mar;38(3):276-278. doi: 10.1038/s41587-020-0439-x. PubMed PMID: 32055031.

## [Nextflow](https://pubmed.ncbi.nlm.nih.gov/28398311/)

> Di Tommaso P, Chatzou M, Floden EW, Barja PP, Palumbo E, Notredame C. Nextflow enables reproducible computational workflows. Nat Biotechnol. 2017 Apr 11;35(4):316-319. doi: 10.1038/nbt.3820. PubMed PMID: 28398311.

## Pipeline tools

- [ART](https://www.niehs.nih.gov/research/resources/software/biostatistics/art/index.cfm)

  > Weichun Huang, Leping Li, Jason R. Myers, Gabor T. Marth, ART: a next-generation sequencing read simulator, Bioinformatics, Volume 28, Issue 4, February 2012, Pages 593–594, https://doi.org/10.1093/bioinformatics/btr708

- [bedtools](https://pubmed.ncbi.nlm.nih.gov/20110278/)

  > Quinlan AR and Hall IM, 2010. BEDTools: a flexible suite of utilities for comparing genomic features. Bioinformatics. 26, 6, pp. 841–842. hhtps://doi.org/10.1093/bioinformatics/btq033

- [Bowtie2](https://www.nature.com/articles/nmeth.1923)

  > Langmead, B., Salzberg, S. Fast gapped-read alignment with Bowtie 2. Nat Methods 9, 357–359 (2012). https://doi.org/10.1038/nmeth.1923

- [CapSim](https://academic.oup.com/bioinformatics/article/34/5/873/4575140)

  > Minh Duc Cao, Devika Ganesamoorthy, Chenxi Zhou, Lachlan J M Coin, Simulating the dynamics of targeted capture sequencing with CapSim, Bioinformatics, Volume 34, Issue 5, March 2018, Pages 873–874, https://doi.org/10.1093/bioinformatics/btx691

- [CRABS](https://onlinelibrary.wiley.com/doi/10.1111/1755-0998.13741)

  > Jeunen, G.-J., Dowle, E., Edgecombe, J., von Ammon, U., Gemmell, N. J., & Cross, H. (2022). crabs—A software program to generate curated reference databases for metabarcoding sequencing data. Molecular Ecology Resources, 00, 1– 14. https://doi.org/10.1111/1755-0998.13741

- [FastQC](https://www.bioinformatics.babraham.ac.uk/projects/fastqc/)

  > Andrews, S. (2010). FastQC: A Quality Control Tool for High Throughput Sequence Data [Online].

- [InSilicoSeq](https://academic.oup.com/bioinformatics/article/35/3/521/5055123)

  > Gourlé H, Karlsson-Lindsjö O, Hayer J and Bongcam+Rudloff E, Simulating Illumina data with InSilicoSeq. Bioinformatics (2018) doi:10.1093/bioinformatics/bty630

- [MultiQC](https://pubmed.ncbi.nlm.nih.gov/27312411/)

  > Ewels P, Magnusson M, Lundin S, Käller M. MultiQC: summarize analysis results for multiple tools and samples in a single report. Bioinformatics. 2016 Oct 1;32(19):3047-8. doi: 10.1093/bioinformatics/btw354. Epub 2016 Jun 16. PubMed PMID: 27312411; PubMed Central PMCID: PMC5039924.

- [ncbi-genome-download](https://zenodo.org/records/8192486)

  > DOI: 10.5281/zenodo.8192432

- [Samtools](https://academic.oup.com/gigascience/article/10/2/giab008/6137722?login=false)

  > Twelve years of SAMtools and BCFtools. Petr Danecek, James K Bonfield, Jennifer Liddle, John Marshall, Valeriu Ohan, Martin O Pollard, Andrew Whitwham, Thomas Keane, Shane A McCarthy, Robert M Davies, Heng Li. GigaScience, Volume 10, Issue 2, February 2021, giab008, https://doi.org/10.1093/gigascience/giab008

- [Wgsim](https://github.com/lh3/wgsim)

## Reference probe/baitset databases

All reference probe databases are sourced from [ultraconserved](https://www.ultraconserved.org/)

- [Tetrapods; 2,560 baits for 2,386 UCEs; version 1](https://academic.oup.com/sysbio/article/61/5/717/1735316)

  > Brant C. Faircloth, John E. McCormack, Nicholas G. Crawford, Michael G. Harvey, Robb T. Brumfield, Travis C. Glenn, Ultraconserved Elements Anchor Thousands of Genetic Markers Spanning Multiple Evolutionary Timescales, Systematic Biology, Volume 61, Issue 5, October 2012, Pages 717–726, https://doi.org/10.1093/sysbio/sys004

- [Tetrapods; 5,472 baits for 5,060 UCEs; version 1](https://royalsocietypublishing.org/doi/10.1098/rspb.2014.0823)

  > Sun Keping, Meiklejohn Kelly A., Faircloth Brant C., Glenn Travis C., Braun Edward L. and Kimball Rebecca T., 2014 The evolution of peafowl and other taxa with ocelli (eyespots): a phylogenomic approach. Proc. R. Soc. B. 281: 20140823. 20140823. http://doi.org/10.1098/rspb.2014.0823

- [Actinopterygians; 2,001 baits for 500 UCEs; version 1](https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0065923)

  > Faircloth BC, Sorenson L, Santini F, Alfaro ME (2013) A Phylogenomic Perspective on the Radiation of Ray-Finned Fishes Based upon Targeted Sequencing of Ultraconserved Elements (UCEs). PLOS ONE 8(6): e65923. https://doi.org/10.1371/journal.pone.0065923

- [Acanthomorphs; 2,628 baits for 1,314 UCEs; version 1](https://royalsocietypublishing.org/doi/10.1098/rspb.2015.1413)

  > McGee Matthew D., Faircloth Brant C., Borstein Samuel R., Zheng Jimmy, Darrin Hulsey C., Wainwright Peter C. and Alfaro Michael E.. 2016 Replicated divergence in cichlid radiations mirrors a major vertebrate innovation. Proc. R. Soc. B. 283: 20151413. 20151413. http://doi.org/10.1098/rspb.2015.1413

- [Arachnida; 14,799 baits for 1,120 UCEs; version 1](https://onlinelibrary.wiley.com/doi/10.1111/1755-0998.12621)

  > Starrett, J., Derkarabetian, S., Hedin, M., Bryson Jr. R. W., McCormack. J. E., & Faircloth. B. C. (2016). High phylogenetic utility of an Ultraconserved element probe set designed for Arachnida. Molecular Ecology Resources. 17(4), 812-823. https://doi.org/10.1111/1755-0998.12621

- [Coleoptera; 13,674 baits for 1,172 UCEs; version 1](https://resjournals.onlinelibrary.wiley.com/doi/10.1111/syen.12244)

  > Baca. S. M., Alexander. A., Gustafson. G. T., & Short. A. E. Z. (2017). Ultraconserved elements show utility in phylogenetic inference of Adephaga (Coleoptera) and suggest paraphyly of Hydradephaga. 42(4), 786-795. https://doi.org/10.1111/syen.12244

- [Diptera; 31,328 baits for 2,711 UCEs; version 1](https://besjournals.onlinelibrary.wiley.com/doi/10.1111/2041-210X.12754)

  > Faircloth. B. C. (2017). Identifying conserved genomic elements and designing universal bait sets to enrich them. Methods in Ecology and Evolution. 8(9), 1103-1112. https://doi.org/10.1111/2041-210X.12754

- [Hemiptera; 40,207 baits for 2,731 UCEs; version 1](https://besjournals.onlinelibrary.wiley.com/doi/10.1111/2041-210X.12754)

  > Faircloth. B. C. (2017). Identifying conserved genomic elements and designing universal bait sets to enrich them. Methods in Ecology and Evolution. 8(9), 1103-1112. https://doi.org/10.1111/2041-210X.12754

- [Hymenoptera; 2,749 baits for 1,510 UCEs; version 1](https://onlinelibrary.wiley.com/doi/10.1111/1755-0998.12328)

  > Faircloth. B. C., Branstetter. M. G., White. N. D., & Brady. S. G. (2014). Target enrichment of ultraconserved elements from anthropods provides a genomic perspective on elationships among Hymenoptera. Molecular Ecology Resources. 15(3), 489-501. https://doi.org/10.1111/1755-0998.12328

- [Hymenoptera; 31,829 baits for 2,590 UCEs; version 2](https://besjournals.onlinelibrary.wiley.com/doi/10.1111/2041-210X.12742)

  > Branstetter. M. G., Longino. J. T., Ward. P. S., & Faircloth. B. C. (2017). Enriching the ant tree of life: enhanced UCE bait set for genome-scale phylogenetics of ants and other Hymenoptera. 8(6), 768-776. https://doi.org/10.1111.2041-210X.12742

- [Anthozoa; 16,306 baits for 720 UCEs and 1,071 exons; version 1](https://onlinelibrary.wiley.com/doi/10.1111/1755-0998.12736)

  > Quattrini. A. M., Faircloth. B. C., Duenas. L. F., Bridge. T. C. L., Brugler. M. R., Calixto-Botia. I. F., DeLeo. D. M., Foret. S., Herrera. S., Lee. S. M. Y., Miller. D. J., Prada. C., Radis-Baptista. G., Ramirez-Portilla. C., Sanchez. J. A., Rodriguez. E., & McFadden. C. S. (2017). Universal target-enrichment baits for anthozoan (Cnidaria) phylogenomics: New approaches to long-standing problems. Molecular Ecology Resources. 18(2), 281-295. https://doi.org/10.1111/1755-0998.12736

## Software packaging/containerisation tools

- [Anaconda](https://anaconda.com)

  > Anaconda Software Distribution. Computer software. Vers. 2-2.4.0. Anaconda, Nov. 2016. Web.

- [Bioconda](https://pubmed.ncbi.nlm.nih.gov/29967506/)

  > Grüning B, Dale R, Sjödin A, Chapman BA, Rowe J, Tomkins-Tinch CH, Valieris R, Köster J; Bioconda Team. Bioconda: sustainable and comprehensive software distribution for the life sciences. Nat Methods. 2018 Jul;15(7):475-476. doi: 10.1038/s41592-018-0046-7. PubMed PMID: 29967506.

- [BioContainers](https://pubmed.ncbi.nlm.nih.gov/28379341/)

  > da Veiga Leprevost F, Grüning B, Aflitos SA, Röst HL, Uszkoreit J, Barsnes H, Vaudel M, Moreno P, Gatto L, Weber J, Bai M, Jimenez RC, Sachsenberg T, Pfeuffer J, Alvarez RV, Griss J, Nesvizhskii AI, Perez-Riverol Y. BioContainers: an open-source and community-driven framework for software standardization. Bioinformatics. 2017 Aug 15;33(16):2580-2582. doi: 10.1093/bioinformatics/btx192. PubMed PMID: 28379341; PubMed Central PMCID: PMC5870671.

- [Docker](https://dl.acm.org/doi/10.5555/2600239.2600241)

  > Merkel, D. (2014). Docker: lightweight linux containers for consistent development and deployment. Linux Journal, 2014(239), 2. doi: 10.5555/2600239.2600241.

- [Singularity](https://pubmed.ncbi.nlm.nih.gov/28494014/)

  > Kurtzer GM, Sochat V, Bauer MW. Singularity: Scientific containers for mobility of compute. PLoS One. 2017 May 11;12(5):e0177459. doi: 10.1371/journal.pone.0177459. eCollection 2017. PubMed PMID: 28494014; PubMed Central PMCID: PMC5426675.
