# European Society of Human Genetics - European Human Genetics Conference - Berlin, Germany, 2020-06

## Reproduce easily: analysis of matching tumor-normal NGS data with the Sarek workflow

Szilveszter Juhos,
Maxime Garcia,
Teresita Díaz de Ståhl,
Markus Mayrhofer,
Johanna Sandgren,
Monica Nistér

### Introduction

High throughput sequencing for precision medicine is now a routine method.
Numerous tools have to be used, and analysis is time consuming.
We propose Sarek, an open-source container based bioinformatics workflow for germline or matching tumor-normal pairs, written in Nextflow, to process WGS, whole-exome or gene-panel samples.

#### Materials and methods

Sarek is part of nf-core, a collection of peer-reviewed workflows; supported environments are Conda, Docker and Singularity.
It is system-agnostic: can be used on single machines, clusters (HPC) or in a cloud such as AWS, with little difference between setups.
Additional software can be included as new modules.
Several model organism references are available (including Human GRCh37 and GRCh38).
The pipeline reports germline and somatic SNVs and SVs (by HaplotypeCaller, Strelka, Mutect2, Manta and TIDDIT).
CNVs, purity and ploidy is estimated by ASCAT and Control-FREEC.
Furthermore, a broad set of QC metrics is reported at the end of the workflow with MultiQC.

#### Results

From FASTQs to annotated VCFs it takes three days for a 90X/90X sample on a 48 cores node.
Sarek is used in production at the National Genomics Infrastructure Sweden for germline and cancer samples for the Swedish Childhood Tumor Biobank and other research groups.

#### Conclusions

Sarek is an easy-to-use tool for germline or cancer NGS samples, to be downloaded from [nf-co.re/sarek](https://nf-co.re/sarek) under MIT license.

#### Supporting grants

Swedish Research Council (2017-00630, 2017-00656), the Swedish Childhood Cancer Fund (BTB: BB2017-0001; BB2018-0001; BB2019-0001), and the Knut and Alice Wallenberg Foundation (KAW 2014.0278).
