/*
 * Decompiled with CFR 0.152.
 */
package matmul.files;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import matmul.files.Block;
import matmul.files.MatmulImpl;

public class Matmul {
    private static int MSIZE;
    private static int BSIZE;
    private static String[][] AfileNames;
    private static String[][] BfileNames;
    private static String[][] CfileNames;
    private static String inputFolder;
    private static String outputFolder;

    private static void usage() {
        System.out.println("    Usage: matmul.files.Matmul <MSize> <BSize>");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            Matmul.usage();
            throw new Exception("[ERROR] Incorrect number of parameters");
        }
        inputFolder = args[0];
        outputFolder = args[1];
        MSIZE = 6;
        BSIZE = 8;
        System.out.println("[LOG] MSIZE parameter value = " + MSIZE);
        System.out.println("[LOG] BSIZE parameter value = " + BSIZE);
        Matmul.initializeVariables(inputFolder, outputFolder);
        Matmul.initializeMatrix(CfileNames, 0);
        Matmul.computeMultiplication();
        System.out.println("[LOG] Main program finished.");
    }

    private static void initializeVariables(String inputFolder, String outputFolder) {
        AfileNames = new String[MSIZE][MSIZE];
        BfileNames = new String[MSIZE][MSIZE];
        CfileNames = new String[MSIZE][MSIZE];
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                Matmul.AfileNames[i][j] = inputFolder + "A." + i + "." + j;
                Matmul.BfileNames[i][j] = inputFolder + "B." + i + "." + j;
                Matmul.CfileNames[i][j] = outputFolder + "C." + i + "." + j;
            }
        }
    }

    private static void initializeMatrix(String[][] fileNames, int initVal) throws Exception {
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                Block.initBlockFile(fileNames[i][j], BSIZE, initVal);
            }
        }
    }

    private static void computeMultiplication() {
        System.out.println("[LOG] Computing result");
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                for (int k = 0; k < MSIZE; ++k) {
                    MatmulImpl.multiplyAccumulative(CfileNames[i][j], AfileNames[i][k], BfileNames[k][j], BSIZE);
                }
            }
        }
    }

    private static void storeMatrix(String fileName) throws Exception {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int i = 0; i < MSIZE; ++i) {
                for (int j = 0; j < MSIZE; ++j) {
                    FileReader filereader = new FileReader(CfileNames[i][j]);
                    BufferedReader br = new BufferedReader(filereader);
                    for (int iblock = 0; iblock < BSIZE; ++iblock) {
                        String nextLine = br.readLine();
                        StringTokenizer tokens = new StringTokenizer(nextLine);
                        for (int jblock = 0; jblock < BSIZE && tokens.hasMoreTokens(); ++jblock) {
                            String value = tokens.nextToken() + " ";
                            fos.write(value.getBytes());
                        }
                    }
                    fos.write("\n".getBytes());
                    br.close();
                    filereader.close();
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new Exception("[ERROR] Error storing result matrix", fnfe);
        }
        catch (IOException ioe) {
            throw new Exception("[ERROR] Error storing result matrix", ioe);
        }
    }

    private static void printMatrix(String[][] fileNames, String name) throws Exception {
        System.out.println("MATRIX " + name);
        for (int i = 0; i < MSIZE; ++i) {
            for (int j = 0; j < MSIZE; ++j) {
                Block aux = new Block(fileNames[i][j], BSIZE);
                aux.printBlock();
            }
            System.out.println("");
        }
    }
}

