/*
 * Decompiled with CFR 0.152.
 */
package matmul.files;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class Block {
    private int BLOCK_SIZE;
    private double[][] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block(String filename, int BSIZE) {
        this.BLOCK_SIZE = BSIZE;
        this.data = new double[this.BLOCK_SIZE][this.BLOCK_SIZE];
        FileReader filereader = null;
        BufferedReader br = null;
        try {
            filereader = new FileReader(filename);
            br = new BufferedReader(filereader);
            for (int i = 0; i < this.BLOCK_SIZE; ++i) {
                String nextLine = br.readLine();
                System.err.println("NEXT : " + nextLine);
                StringTokenizer tokens = new StringTokenizer(nextLine);
                for (int j = 0; j < this.BLOCK_SIZE && tokens.hasMoreTokens(); ++j) {
                    this.data[i][j] = Double.parseDouble(tokens.nextToken());
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (filereader != null) {
                    filereader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void multiplyAccum(Block a, Block b) {
        for (int i = 0; i < this.BLOCK_SIZE; ++i) {
            for (int j = 0; j < this.BLOCK_SIZE; ++j) {
                for (int k = 0; k < this.BLOCK_SIZE; ++k) {
                    double[] dArray = this.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + a.data[i][k] * b.data[k][j];
                }
            }
        }
    }

    protected void printBlock() {
        for (int i = 0; i < this.BLOCK_SIZE; ++i) {
            for (int j = 0; j < this.BLOCK_SIZE; ++j) {
                System.out.print(this.data[i][j] + " ");
            }
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockToDisk(String filename) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            for (int i = 0; i < this.BLOCK_SIZE; ++i) {
                for (int j = 0; j < this.BLOCK_SIZE; ++j) {
                    String str = new Double(this.data[i][j]).toString() + " ";
                    fos.write(str.getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public static void initBlockFile(String filename, int BSIZE, int initVal) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            for (int iblock = 0; iblock < BSIZE; ++iblock) {
                for (int jblock = 0; jblock < BSIZE; ++jblock) {
                    double value = initVal;
                    fos.write(String.valueOf(value).getBytes());
                    fos.write(" ".getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.write("\n".getBytes());
        }
        catch (IOException e) {
            throw new Exception("[ERROR] Error initializing matrix", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    throw new Exception("[ERROR] Error closing matrix file", e);
                }
            }
        }
    }
}

