#!/usr/bin/env python3

import yaml
import pathlib

# yaml makes me cry
# https://github.com/yaml/pyyaml/issues/98#issuecomment-436814271
# This was causing a warning of NA coercion in R because some kegg pathways were specified as "03602,034,0230"
# and were not being quoted properly by this pkg
from yaml import Dumper


def string_representer(dumper, value):
    if value.startswith("0"):
        return dumper.represent_scalar(TAG_STR, value, style="'")
    return dumper.represent_scalar(TAG_STR, value)


TAG_STR = "tag:yaml.org,2002:str"
Dumper.add_representer(str, string_representer)


stages = dict()
for filename in (
    "dvc-download.yaml",
    "dvc-rnaseq.yaml",
    "dvc-srna.yaml",
    "dvc-proteomics.yaml",
    "dvc-integration.yaml",
    "dvc-wgcna.yaml",
    "dvc-mofa.yaml",
    "dvc-dtu.yaml",
    "dvc-das.yaml",
    "dvc-phosphoproteomics.yaml",
):
    with pathlib.Path("dvc", filename).open() as fh:
        dvc_spec = yaml.safe_load(fh)
        if dvc_spec is None:
            continue
        cur_stage = dvc_spec.get("stages", None)
        if cur_stage is None:
            continue
        stages.update(cur_stage)

with open("dvc.yaml", "w") as fh:
    fh.write("# Autogenerated file with ./create-dvc-yaml.py. DO NOT EDIT\n")
    yaml.dump({"stages": stages}, fh)


params = dict()
for filename in (
    "params-rnaseq.yaml",
    "params-srna.yaml",
    "params-proteomics.yaml",
    "params-integration.yaml",
    "params-wgcna.yaml",
    "params-mofa.yaml",
    "params-dtu.yaml",
    "params-das.yaml",
    "params-phosphoproteomics.yaml",
):
    with pathlib.Path("params", filename).open() as fh:
        params_spec = yaml.safe_load(fh)
        if params_spec is None:
            continue
        params.update(params_spec)

with open("params.yaml", "w") as fh:
    fh.write("# Autogenerated file with ./create-dvc-yaml.py. DO NOT EDIT\n")
    yaml.dump(params, fh)
