cwlVersion: v1.2
class: Workflow
doc: >-
  The workflow starts with selecting chr10:g.3823823G>A as the search term. The
  closest gene to the variant was found using MyVariant.info[1]. RNA-seq-like
  LINCS L1000 Signatures[3] which mimick or reverse the the expression of KLF6
  were visualized. Median expression of KLF6 was obtained from the GTEx
  Portal[8] using the portal's API. To visualize the scored tissues, a vertical
  bar plot was created Fig.. 

  1. Lelong, S. et al. BioThings SDK: a toolkit for building high-performance
  data APIs in biomedical research. Bioinformatics vol. 38 2077–2079 (2022).
  doi:10.1093/bioinformatics/btac017

  3. Evangelista, J. E. et al. SigCom LINCS: data and metadata search engine for
  a million gene expression signatures. Nucleic Acids Research vol. 50 W697–W709
  (2022). doi:10.1093/nar/gkac328

  8. Lonsdale, J. et al. The Genotype-Tissue Expression (GTEx) project. Nature
  Genetics vol. 45 580–585 (2013). doi:10.1038/ng.2653
requirements: {}
inputs:
  step-1-data:
    label: Variant Input
    doc: Start with a Variant
    type: File
outputs:
  step-1-output:
    label: Variant
    doc: Variant Term
    type: File
    outputSource: step-1/output
  step-2-output:
    label: Gene
    doc: Gene Term
    type: File
    outputSource: step-2/output
  step-3-output:
    label: LINCS L1000 Reverse Search Dashboard
    doc: A dashboard for performing L1000 Reverse Search queries for a given gene
    type: File
    outputSource: step-3/output
  step-4-output:
    label: Scored Tissues
    doc: ZScores of Tissues
    type: File
    outputSource: step-4/output
  step-5-output:
    label: Plotly Plot
    doc: A plot rendered using the [plotly.js
      library](https://plotly.com/javascript/)
    type: File
    outputSource: step-5/output
steps:
  step-1:
    run: Input[Variant].cwl
    label: Variant Input
    doc: Start with a Variant
    in:
      data:
        source: step-1-data
      outputFilename:
        default: step-1-output.json
    out:
      - output
  step-2:
    run: GeneTermFromVariantTerm.cwl
    label: Identify Closest Gene to Variant (Legacy)
    doc: Identify the closest gene to this variant
    in:
      inputs.variant:
        label: Variant
        source: step-1/output
      outputFilename:
        default: step-2-output.json
    out:
      - output
  step-3:
    run: LINCSL1000ReverseSearch.cwl
    label: LINCS L1000 Reverse Search
    doc: Identify RNA-seq-like LINCS L1000 Signatures which reverse the expression
      of the gene.
    in:
      inputs.gene:
        label: Gene
        source: step-2/output
      outputFilename:
        default: step-3-output.json
    out:
      - output
  step-4:
    run: GTExTissueExpressionFromGene.cwl
    label: Query GTEx Median Tissue Expression
    doc: Use GTEx API to obtain median tissue expression for the given gene
    in:
      inputs.gene:
        label: Gene
        source: step-2/output
      outputFilename:
        default: step-4-output.json
    out:
      - output
  step-5:
    run: BarplotFrom[Scored[Tissue]].cwl
    label: Vertical bar plot from Scored Tissues
    doc: Construct a vertical bar plot with Scored Tissues
    in:
      inputs.terms:
        label: Scored Tissues
        source: step-4/output
      outputFilename:
        default: step-5-output.json
    out:
      - output
