cwlVersion: v1.0
class: CommandLineTool
label: Resolve a Gene Count Matrix from a File
doc: Ensure a file contains a gene count matrix, load it into a standard format
baseCommand:
  - /app/cli/pwb.sh
  - GeneCountMatrixFromFile
requirements:
  - class: DockerRequirement
    dockerImageId: maayanlab/playbook-partnership:0.73.1
inputs:
  inputs.file:
    label: File URL
    doc: URL to a File
    type: File
    inputBinding:
      prefix: --inputs.file=
      separate: false
  outputFilename:
    type: string
    default: output.json
    inputBinding:
      prefix: --output=
      separate: false
outputs:
  output:
    label: Gene Count Matrix
    doc: A gene count matrix file
    type: File
    outputBinding:
      glob: $(inputs.outputFilename)
