# Contributing to ETHOS.REFLOW

We welcome contributions to ETHOS.REFLOW and are grateful for every contribution made by the community. This document is intended to help you understand the process for contributing effectively.

## How to Contribute

### Step 1: Find an Issue or Create One

Before starting to work on a contribution, please check the existing issues for similar contributions. If you find an issue that you want to work on, comment that you would like to do so to prevent duplicating efforts.

If there is no existing issue related to your contribution, please create one. Provide as much information as possible to describe the issue or feature request, including:

- Detailed description of the issue or feature
- Possible solutions or features you're considering
- Any relevant examples or context

### Step 2: Fork the Repository

To work on an issue or a feature, start by forking the repository. This will create a copy of the repository under your GitHub account where you can make changes.

### Step 3: Create a Branch

From your forked repository, create a branch where you can make your changes. It is a best practice to name your branch something relevant to the issue or feature, for example:

```bash
git checkout -b feature/add-feature
```
or 
```bash
git checkout -b fix/add-fix
```

## Step 4: Make Your Changes

Make the necessary changes in your branch. Be sure to keep your changes as focused as possible. If the changes are too broad, it may be difficult to review and merge your pull request.

## Step 5: Commit Your Changes

When you're happy with your changes, commit them to your branch. Use meaningful commit messages that explain the changes made. For example:

```bash
git commit -m "Fixed error with Climate Data Store API login"
```

## Step 6: Push Your Changes

Push your changes to your forked repository. This will make your changes available for a pull request.

```bash
git push origin feature/add-feature
```
or 
```bash
git push origin fix/add-fix
```

## Step 7: Submit a Pull Request

Go to the original repository you forked on GitHub. You should see a `Compare & pull` request button for the branch you recently pushed. Click it and review the changes. Make sure to write a clear description of what this pull request does and reference the related issue (e.g., "Closes #123").

## Step 8: Code Review

Once the pull request is submitted, maintainers of the original repository will review your work. Be open to feedback and make changes if needed. This is a collaborative process, and iterations and discussions are normal.

## Step 9: Merge

Once the pull request is approved, it will be merged into the original repository. Congratulations! You have successfully contributed to ETHOS.REFLOW.

## Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](CODE_OF_CONDUCT.md). By participating in this project you agree to abide by its terms. 

## Questions? 

If you have any questions about contributing to ETHOS.REFLOW, please contact the project lead, [Tristan Pelser](mailto:t.pelser@fz-juelich.de)

