/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.BitSet;

public class FindTelomereWindows {
    private static final NumberFormat nf = new DecimalFormat("############.#");
    private static final int WINDOW_SIZE = 1000;
    private static final int MIN_OFFSET = 0;
    private static double THRESHOLD = 0.4;

    public static void printUsage() {
        System.err.println("This program sizes a fasta or fastq file. Multiple fasta files can be supplied by using a comma-separated list.");
        System.err.println("Example usage: getHist fasta1.fasta,fasta2.fasta");
    }

    public static void processScaffold(String string, BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        for (int i = 0; i <= bitSet.size() - 0 - 1000; i += 200) {
            int n = bitSet.get(i, i + 1000).cardinality();
            if (!((double)n / 1000.0 >= THRESHOLD)) continue;
            System.out.println("Window\t" + string + "\t" + bitSet.size() + "\t" + i + "\t" + (i + 1000) + "\t" + (double)n / 1000.0);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            FindTelomereWindows.printUsage();
            System.exit(1);
        }
        BitSet bitSet = null;
        String string = null;
        Double d = Double.parseDouble(stringArray[1]) / 100.0;
        System.err.println("Given error rate of " + d + " running with adjusted threshold of " + (THRESHOLD *= Math.pow(d, 6.0)) + " due to survival prob " + Math.pow(d, 6.0));
        BufferedReader bufferedReader = Utils.getFile(stringArray[0], "telomere");
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray2 = string2.trim().split("\\s+");
            if (bitSet == null || !stringArray2[0].equalsIgnoreCase(string)) {
                FindTelomereWindows.processScaffold(string, bitSet);
                bitSet = new BitSet(Integer.parseInt(stringArray2[1]));
                string = stringArray2[0];
            }
            bitSet.set(Integer.parseInt(stringArray2[3]), Integer.parseInt(stringArray2[4]));
        }
        FindTelomereWindows.processScaffold(string, bitSet);
        bufferedReader.close();
    }
}

