/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class SizeFasta {
    private static final NumberFormat nf = new DecimalFormat("############.#");
    private static final String[] FASTA_ENDS = new String[]{"trimmed", "contig", "RELEASE5", "bases", "qual", "fasta", "fas", "fna", "fa", "genome"};
    private static final String[] FASTQ_ENDS = new String[]{"seq", "txt", "fastq", "fq"};
    private static final int MAX_DEFAULT_STRING = 4000000;
    private boolean skipNs = false;
    private boolean stopEarly = false;

    public void processFasta(String string) throws Exception {
        BufferedReader bufferedReader = Utils.getFile(string, FASTA_ENDS, true);
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(4000000);
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.startsWith(">")) {
                if (string3.length() > 0) {
                    System.out.println(string3 + "\t" + (this.skipNs ? stringBuffer.toString().replaceAll("N", "").length() : stringBuffer.length()));
                    if (this.stopEarly) {
                        System.exit(0);
                    }
                }
                string3 = string2.substring(1);
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() != 0) {
            System.out.println(string3 + "\t" + (this.skipNs ? stringBuffer.toString().replaceAll("N", "").length() : stringBuffer.length()));
        }
        bufferedReader.close();
    }

    public long sizeSingleRecord(String string) throws Exception {
        BufferedReader bufferedReader = Utils.getFile(string, FASTA_ENDS);
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(4000000);
        String string3 = "";
        long l = 0L;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.startsWith(">")) {
                if (string3.length() > 0) {
                    l += (long)stringBuffer.length();
                }
                string3 = string2.substring(1);
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() != 0) {
            l += (long)stringBuffer.length();
        }
        bufferedReader.close();
        return l;
    }

    public void processFastq(String string) throws Exception {
        BufferedReader bufferedReader = Utils.getFile(string, FASTQ_ENDS);
        if (bufferedReader == null) {
            bufferedReader = Utils.getFile(string, "fq");
        }
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3 = string2.split("\\s+")[0].substring(1).trim();
            String string4 = bufferedReader.readLine();
            String string5 = bufferedReader.readLine();
            String string6 = string5.split("\\s+")[0].substring(1).trim();
            if (string6.length() != 0 && !string6.equals(string3)) {
                System.err.println("Error ID " + string3 + " (" + string6.length() + ") DOES not match quality ID " + string6);
                System.exit(1);
            }
            String string7 = bufferedReader.readLine();
            System.out.println(string3 + "\t" + string7.length() + "\t" + (this.skipNs ? string4.replaceAll("N", "").length() : string4.length()));
            if (!this.stopEarly) continue;
            System.exit(0);
        }
        bufferedReader.close();
    }

    public static void printUsage() {
        System.err.println("This program sizes a fasta or fastq file. Multiple fasta files can be supplied by using a comma-separated list.");
        System.err.println("Example usage: SizeFasta fasta1.fasta,fasta2.fasta");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            SizeFasta.printUsage();
            System.exit(1);
        }
        SizeFasta sizeFasta = new SizeFasta();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-skip")) {
                sizeFasta.skipNs = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-first")) {
                sizeFasta.stopEarly = true;
                continue;
            }
            String[] stringArray2 = stringArray[i].trim().split(",");
            for (int j = 0; j < stringArray2.length; ++j) {
                boolean bl = false;
                System.err.println("Processing file " + stringArray2[j]);
                for (String string : FASTA_ENDS) {
                    if (!stringArray2[j].contains(string) || stringArray2[j].contains("fastq") || stringArray2[j].contains("fq") || stringArray2[j].contains("txt")) continue;
                    sizeFasta.processFasta(stringArray2[j]);
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (stringArray2[j].contains("seq") || stringArray2[j].contains("fastq") || stringArray2[j].contains("fq") | stringArray2[j].contains("txt")) {
                    sizeFasta.processFastq(stringArray2[j]);
                    continue;
                }
                sizeFasta.processFasta(stringArray2[j]);
            }
        }
    }
}

