/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.regex.Pattern;

public class Utils {
    public static final int MBYTES = 0x100000;
    public static final int FASTA_LINE_LENGTH = 60;
    public static MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
    public static final String[] FASTA_ENDS = new String[]{"trimmed", "contig", "qual", "fasta", "fas", "fna", "fa", "genome"};
    public static final Pattern spaceSplit = Pattern.compile("\\s+");
    public static final Pattern tabSplit = Pattern.compile("\\t+");

    public static BufferedReader getFile(String string, String string2) throws Exception {
        String[] stringArray = new String[]{string2};
        return Utils.getFile(string, stringArray);
    }

    public static BufferedReader getFile(String string, String[] stringArray) throws Exception {
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(Utils.getFileStream(string, stringArray, false)));
        bufferedReader.ready();
        return bufferedReader;
    }

    public static BufferedReader getFile(String string, String[] stringArray, boolean bl) throws Exception {
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(Utils.getFileStream(string, stringArray, bl)));
        bufferedReader.ready();
        return bufferedReader;
    }

    public static InputStream getFileStream(String string, String[] stringArray) throws Exception {
        return Utils.getFileStream(string, stringArray, false);
    }

    public static InputStream getFileStream(String string, String[] stringArray, boolean bl) throws Exception {
        InputStream inputStream = null;
        if (string.endsWith("bz2")) {
            System.err.println("Running command bzip2 -dc " + new File(string).getAbsolutePath() + " |");
            Process process = Runtime.getRuntime().exec("bzip2 -dc " + new File(string).getAbsolutePath() + " |");
            inputStream = process.getInputStream();
        } else if (string.endsWith("gz")) {
            System.err.println("Runnning comand gzip -dc " + new File(string).getAbsolutePath() + " |");
            Process process = Runtime.getRuntime().exec("gzip -dc " + new File(string).getAbsolutePath() + " |");
            inputStream = process.getInputStream();
        } else if (string.endsWith("zip")) {
            System.err.println("Runnning comand unzip -p " + new File(string).getAbsolutePath() + " |");
            Process process = Runtime.getRuntime().exec("unzip -p " + new File(string).getAbsolutePath() + " |");
            inputStream = process.getInputStream();
        } else {
            for (String string2 : stringArray) {
                if (!string.endsWith(string2)) continue;
                inputStream = new FileInputStream(string);
                return inputStream;
            }
            if (bl) {
                inputStream = new FileInputStream(string);
                return inputStream;
            }
            System.err.println("Unknown file format " + string + " Skipping!");
        }
        return inputStream;
    }

    public static String convertToFasta(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String[] stringArray = string.trim().split("\\s+");
        if (stringArray.length > 1) {
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(stringArray[n]);
                n2 += stringArray[n].length();
                if (n == stringArray.length - 1) continue;
                if (n2 >= 60) {
                    n2 = 0;
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append(" ");
            }
        } else {
            n = 0;
            while (n + 60 < string.length()) {
                stringBuffer.append(string.substring(n, n + 60));
                stringBuffer.append("\n");
                n += 60;
            }
            stringBuffer.append(string.substring(n, string.length()));
        }
        return stringBuffer.toString();
    }

    public static String rc(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c != '-') {
                Translate translate = Translate.valueOf(Character.toString(c).toUpperCase());
                stringBuilder.append(translate.getCompliment());
                continue;
            }
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public static void outputFasta(PrintStream printStream, String string, String string2) {
        Utils.outputFasta(printStream, string, null, string2, ">", null, true);
    }

    public static void outputFasta(String string, String string2, String string3, String string4, String string5, boolean bl) {
        Utils.outputFasta(System.out, string, string2, string3, string4, string5, bl);
    }

    public static void outputFasta(PrintStream printStream, String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (string.length() == 0) {
            return;
        }
        if (string2 != null && string2.length() != string.length()) {
            System.err.println("Error length of sequences and fasta for id " + string3 + " aren't equal fasta: " + string.length() + " qual: " + string2.length());
            System.exit(1);
        }
        printStream.println(string4 + string3);
        printStream.println(bl ? Utils.convertToFasta(string) : string);
        if (string2 != null) {
            printStream.println(string5 + string3);
            printStream.println(bl ? Utils.convertToFasta(string2) : string2);
        }
    }

    public static String getUngappedRead(String string) {
        string = string.replaceAll("N", "");
        string = string.replaceAll("-", "");
        assert (string.length() >= 0);
        return string;
    }

    public static int countLetterInRead(String string, String string2) {
        return Utils.countLetterInRead(string, string2, false);
    }

    public static int countLetterInRead(String string, String string2, boolean bl) {
        String string3 = Utils.getUngappedRead(string);
        int n = string3.length();
        if (n == 0) {
            return -1;
        }
        int n2 = string2.length();
        int n3 = 0;
        for (int i = 0; i <= string3.length() - n2; i += n2) {
            if (string2.equals(string3.substring(i, i + n2)) && bl) {
                ++n3;
            }
            if (!string2.equalsIgnoreCase(string3.substring(i, i + n2)) || bl) continue;
            ++n3;
        }
        return n3;
    }

    public static String toProtein(String string, boolean bl, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            string = Utils.rc(string);
        }
        string = string.replaceAll("-", "");
        for (int i = n; i < string.length() - 3; i += 3) {
            String string2 = string.substring(i, i + 3);
            String string3 = ToProtein.valueOf(string2).getProtein();
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static int checkForEnd(String string, int n) {
        if (string.startsWith("{")) {
            ++n;
        }
        if (string.startsWith("}")) {
            --n;
        }
        if (n == 0) {
            return -1;
        }
        return n;
    }

    public static String getID(String string) {
        String[] stringArray = string.split(":");
        int n = stringArray[1].indexOf(",");
        if (n != -1) {
            return stringArray[1].substring(1, n).trim();
        }
        return stringArray[1].trim();
    }

    public static String getValue(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.split(":")[1];
        }
        return null;
    }

    public static int getOvlSize(int n, int n2, int n3, int n4) {
        if (n3 <= 0 && n4 >= 0 || n3 >= 0 && n4 <= 0) {
            return -1;
        }
        if (n3 < 0) {
            return n - Math.abs(n4);
        }
        return n - n3;
    }

    public static int getRangeOverlap(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n2);
        int n6 = Math.min(n3, n4);
        int n7 = Math.max(n, n2);
        int n8 = Math.max(n3, n4);
        int n9 = Math.max(n5, n6);
        int n10 = Math.min(n7, n8);
        return n10 - n9 + 1;
    }

    public static enum ToProtein {
        GCT("A"),
        GCC("A"),
        GCA("A"),
        GCG("A"),
        TTA("L"),
        TTG("L"),
        CTT("L"),
        CTC("L"),
        CTA("L"),
        CTG("L"),
        CGT("R"),
        CGC("R"),
        CGA("R"),
        CGG("R"),
        AGA("R"),
        AGG("R"),
        AAA("K"),
        AAG("K"),
        AAT("N"),
        AAC("N"),
        ATG("M"),
        GAT("D"),
        GAC("D"),
        TTT("F"),
        TTC("F"),
        TGT("C"),
        TGC("C"),
        CCT("P"),
        CCC("P"),
        CCA("P"),
        CCG("P"),
        CAA("Q"),
        CAG("Q"),
        TCT("S"),
        TCC("S"),
        TCA("S"),
        TCG("S"),
        AGT("S"),
        AGC("S"),
        GAA("E"),
        GAG("E"),
        ACT("T"),
        ACC("T"),
        ACA("T"),
        ACG("T"),
        GGT("G"),
        GGC("G"),
        GGA("G"),
        GGG("G"),
        TGG("W"),
        CAT("H"),
        CAC("H"),
        TAT("Y"),
        TAC("Y"),
        ATT("I"),
        ATC("I"),
        ATA("I"),
        GTT("V"),
        GTC("V"),
        GTA("V"),
        GTG("V"),
        TAG("X"),
        TGA("X"),
        TAA("X");

        private String other;

        public String getProtein() {
            return this.other;
        }

        private ToProtein(String string2) {
            this.other = string2;
        }
    }

    public static enum Translate {
        A("T"),
        C("G"),
        G("C"),
        T("A"),
        N("N"),
        R("?"),
        Y("?"),
        K("?"),
        M("?"),
        S("?"),
        W("?"),
        D("?"),
        V("?"),
        H("?"),
        B("?");

        private String other;

        public String getCompliment() {
            if (this == R) {
                double d = Math.random();
                this.other = d < 0.5 ? "T" : "C";
            } else if (this == Y) {
                double d = Math.random();
                this.other = d < 0.5 ? "G" : "A";
            } else if (this == K) {
                double d = Math.random();
                this.other = d < 0.5 ? "A" : "C";
            } else if (this == M) {
                double d = Math.random();
                this.other = d < 0.5 ? "G" : "T";
            } else if (this == S) {
                double d = Math.random();
                this.other = d < 0.5 ? "C" : "G";
            } else if (this == W) {
                double d = Math.random();
                this.other = d < 0.5 ? "T" : "A";
            } else if (this == D) {
                double d = Math.random() * 3.0;
                this.other = d < 1.0 ? "T" : (d < 2.0 ? "C" : "A");
            } else if (this == V) {
                double d = Math.random() * 3.0;
                this.other = d < 1.0 ? "T" : (d < 2.0 ? "G" : "C");
            } else if (this == H) {
                double d = Math.random() * 3.0;
                this.other = d < 1.0 ? "T" : (d < 2.0 ? "G" : "A");
            } else if (this == B) {
                double d = Math.random() * 3.0;
                this.other = d < 1.0 ? "G" : (d < 2.0 ? "C" : "A");
            }
            return this.other;
        }

        private Translate(String string2) {
            this.other = string2;
        }
    }

    public static class Pair {
        public int first;
        public double second;
        public boolean orient;
        public String id;

        public Pair(int n, double d) {
            this.first = n;
            this.second = d;
        }

        public Pair(int n, double d, boolean bl) {
            this.first = n;
            this.second = d;
            this.orient = bl;
        }

        public Pair(int n, double d, boolean bl, String string) {
            this.first = n;
            this.second = d;
            this.orient = bl;
            this.id = string;
        }
    }

    public static class FastaReader {
        private BufferedReader fileIn = null;
        private String header = "";

        public FastaReader(String string) throws Exception {
            this.fileIn = Utils.getFile(string, FASTA_ENDS);
        }

        public FastaRecord readRecord() throws Exception {
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            FastaRecord fastaRecord = null;
            while ((string = this.fileIn.readLine()) != null) {
                if (string.startsWith(">")) {
                    if (this.header.length() > 0) {
                        fastaRecord = new FastaRecord(this.header, stringBuilder.toString());
                        this.header = string.substring(1);
                        break;
                    }
                    this.header = string.substring(1);
                    continue;
                }
                stringBuilder.append(string);
            }
            if (fastaRecord == null && stringBuilder.length() != 0) {
                fastaRecord = new FastaRecord(this.header, stringBuilder.toString());
            }
            return fastaRecord;
        }

        public void close() throws Exception {
            this.fileIn.close();
        }
    }

    public static class FastaRecord {
        public String header = null;
        public String name = null;
        public String sequence = null;
        public String[] split = null;

        public FastaRecord(String string, String string2) {
            this.split = string.trim().split("\\s+");
            this.name = this.split[0];
            this.header = string;
            this.sequence = string2;
        }
    }
}

