process GRAPHOVERALLCOVERAGE {
    tag "$meta.id"
    label 'process_single'

    conda "conda-forge::perl=5.26.2"
    container "${ workflow.containerEngine == 'singularity' && !task.ext.singularity_pull_docker_container ?
        'https://depot.galaxyproject.org/singularity/perl:5.26.2' :
        'biocontainers/perl:5.26.2' }"

    input:
    tuple val(meta), path(bed)

    output:
    tuple val(meta), path("*.part") , emit: part
    path "versions.yml"             , emit: versions

    when:
    task.ext.when == null || task.ext.when

    script:
    def args = task.ext.args ?: ''
    def prefix = task.ext.prefix ?: "${meta.id}"
    """
    graph_overall_coverage.pl $bed > ${prefix}.part

    cat <<-END_VERSIONS > versions.yml
    "${task.process}":
        perl: \$(echo \$(perl --version 2>&1) | awk '/This/ {print \$9}'))
        graph_overall_coverage.pl: \$(graph_overall_coverage.pl --version)
    END_VERSIONS
    """

    stub:
    def prefix = task.ext.prefix ?: "${meta.id}"
    """
    touch ${prefix}.part

    cat <<-END_VERSIONS > versions.yml
    "${task.process}":
        perl: \$(echo \$(perl --version 2>&1) | awk '/This/ {print \$9}'))        graph_overall_coverage.pl: \$(graph_overall_coverage.pl --version)
    END_VERSIONS
    """
}
