# 🧬 Click-qPCR 日本語版ユーザーガイド 🧬

Click-qPCRは，リアルタイム定量PCR（qPCR）データ解析のために設計されたユーザーフレンドリーなShinyウェブアプリケーションです。

**このツールはウェブブラウザ（<https://kubo-azu.shinyapps.io/Click-qPCR/>）からすぐに利用でき，ローカルへのインストールが不要です。**

ユーザーはCq（定量サイクル）値を含むCSVファイルをアップロードすることで，ΔCq および ΔΔCq の計算を実行できます。個々のデータポイントを含む棒グラフとして結果を視覚化し，統計サマリーと出版品質のプロットの両方をダウンロードできます。

アプリケーションをローカルで実行または修正したいユーザーのために，ソースコードも利用可能です（下記の「インストールと使い方」セクションを参照）。

このツールは，一般的なqPCRデータ解析のワークフローを簡素化し，表計算ソフトによる煩雑な解析やプログラミングの知識なしに再現性ある解析を実行することを目的としています。

### <ins>注意</ins>

このリポジトリには，プレプリントに付随する Shiny アプリのソースコードが含まれています。

A. Kubota and A. Tajima, *bioRxiv*. (2025). <https://doi.org/10.1101/2025.05.29.656779>.

**このアプリやコードを研究で使用する場合は，この論文を必ず引用してください。（学会発表や卒業研究含む）**

## 特徴

-   **インタラクティブなデータアップロード:** CSV形式のqPCRデータを簡単にアップロードできます。データフォーマットを理解するためのテンプレートが提供されています。

-   **データプレビュー:** アップロードしたデータの最初の10行を表示し, 正しく読み込まれていることを確認できます。

-   **タブベースの解析:** ユーザーインターフェースは異なる解析のためのタブに整理されています。

    -   **前処理とΔCq解析:**
        -   1つまたは**複数のリファレンス遺伝子**を選択します。ΔCqは，選択されたリファレンス遺伝子の平均Cqを使用して計算されます。
        -   1つ以上のターゲット遺伝子を選択します。
        -   直感的なインターフェースを使用して，**複数のグループ比較を同時に**設定できます。
        -   相対発現量（2<sup>-ΔCq</sup>）を計算します。
        -   指定された各ペアについて，統計的有意性のためにWelchの *t* 検定を実行します。
        -   平均±SDを示す包括的な棒グラフと，個々のデータポイントを重ねてすべての結果を視覚化します。

    -   **ΔΔCq解析:**
        -   `Preprocessing and ΔCq Analysis`タブで選択されたリファレンス遺伝子が自動的に使用されます。
        -   ターゲット遺伝子、ベース/コントロールグループ、および1つ以上のトリートメントグループを選択します。
        -   ベースグループに対するフォールドチェンジ（2<sup>-ΔΔCq</sup>）を計算します。
        -   統計的有意性のためにWelchの *t* 検定を実行します。
        -   棒グラフで結果を視覚化します。

    -   **ANOVA (Dunnett's post-hoc):**
        -   3つ以上のグループを比較するために設計されています。
        -   **一元配置分散分析（one-way ANOVA）**を実行し，それに続いて**Dunnettの多重比較検定（post-hoc test）**を行い，各トリートメントグループを単一のコントロールグループと比較します。
        -   結果は，`ΔCq ANOVA (Dunnett's post-hoc)`タブで相対発現量（2<sup>-ΔCq</sup>）として視覚化されます。
        -   同じ統計結果は，`ΔΔCq ANOVA (Dunnett's post-hoc)`タブでフォールドチェンジ（2<sup>-ΔΔCq</sup>）として視覚化できます。

-   **高度なダウンロードとプロット作成:**
    -   **カスタムプロット寸法:** スライダーを使用し，ダウンロードするプロットの幅・高さ・解像度（DPI）をインタラクティブに調整できます。 ※ DPIはPNG形式のみ調整可能
    -   **固定アスペクト比:** サイズ変更中にプロットのアスペクト比をオプションでロックできます。
    -   **2つのダウンロードモード:**
        1.  **プロットのダウンロード:** カスタムの寸法とDPI設定を使用して画像を保存します。
        2.  **表示サイズの保存:** 画面に表示されているプロットと同じ画像を保存します。
    -   **プロット色のカスタマイズ:** プレゼンテーションや論文に合わせてグラフの外観をカスタマイズ可能です。


        | パレット名                        | 主な特徴と推奨用途                                             |
        | :----------------------------- | :--------------------------------------------------------- |
        | **Default (ggplot2)** | 標準的な`ggplot2`のテーマです。 |
        | **Balanced (Set2)** | 明確で区別しやすい色のセットで，目に優しくスクリーン上での表示に適しています。 |
        | **Colorblind-Friendly (Viridis)** | 色覚多様性を持つ方々を含め，誰もがプロットを正確に読み取れるようにします。 |
        | **Paired (Paired Colors)** | 明暗のペアで構成された色です。ペアや関連の深い実験群を比較するような分析に最適です。 |
        | **Pastel (Pastel1)** | 彩度の低い色のセレクションです。あまり主張の強くないデザインが好まれる場合に適しています。 |
        | **Grayscale (for printing)** | プロットをグレーの濃淡で描画します。 |


-   **堅牢性:**
    -   データが不十分な場合や分散がゼロの場合でも，クラッシュすることなく適切に処理します。
    -   *p*-valueを計算できない場合，結果テーブルに明確なメッセージ（例：Zero variance）を提供します。

-   **診断タブ:**
    -   このタブはアプリの自己診断機能を提供します。`Run Diagnostics`ボタンを押すと，アプリに内蔵されたサンプルデータを用いて，以下の4つの主要な機能が正しく動作しているかを自動でテストします。
        1. サンプルデータの読み込み
        2. ΔCq解析（ *t* 検定）の検証
        3. ΔΔCq解析（フォールドチェンジ）の検証
        4. ANOVAとDunnettの検定の検証
    -   各テストの結果が**Passed ✅**と表示されれば，アプリの基本的な計算・統計処理機能が正常に動作していることを確認できます。これは，特にローカル環境でインストールした際の動作確認や，自身でコードを改変したりした場合に，アプリの健全性を確認するのに役立ちます。


## インストールと使い方

アプリはオンラインで利用可能ですが，ローカルで実行することもできます。


### 前提条件

-   R (バージョン4.1以降を推奨)
-   以下のRパッケージ: `shiny`, `shinyjs`, `readr`, `dplyr`, `ggplot2`, `tidyr`, `DT`, `RColorBrewer`, `fontawesome`, `multcomp`

* R (バージョン 4.4.2 以降を推奨)
* RStudio (使いやすさのため推奨しますが，Rコンソールから実行する場合は必須ではありません)
* 以下のRパッケージ（およびそれらの依存パッケージ）:
    * `shiny`
    * `shinyjs`
    * `readr`
    * `dplyr`
    * `ggplot2`
    * `tidyr`
    * `DT`
    * `RColorBrewer`
    * `fontawesome`
    * `multcomp`

これらのパッケージはRで以下のようにインストールできます:

```R
install.packages(c("shiny", "shinyjs", "readr", "dplyr", "ggplot2", "tidyr", "DT", "RColorBrewer", "fontawesome", "multcomp"))
```


### アプリケーションの実行

<ins>Option 1: GitHubから直接実行</ins>

RまたはRStudio内で shiny::runGitHub() 関数を使用してGitHubから直接実行できます:

```R
if (!requireNamespace("shiny", quietly = TRUE)) install.packages("shiny")
shiny::runGitHub("kubo-azu/Click-qPCR")
```

<ins>Option 2: リポジトリをローカルにクローンする</ins>

1. このリポジトリをユーザのローカルマシン（お使いのPC）にクローンします:

```sh
git clone https://github.com/kubo-azu/Click-qPCR.git
```

2. Rでクローンしたディレクトリに移動するか，RStudioで Click-qPCR.Rproj ファイルを開きます。

3. `renv` を使用している場合（再現性のために推奨）はR環境を復元します:

```R
if (!requireNamespace("renv", quietly = TRUE)) install.packages("renv")
renv::restore()
```

4. アプリケーションを実行:

```R
shiny::runApp()
```


## データ形式

以下の4つの列を持つCSVファイルとしてデータを準備してください。

-   `sample`: 各サンプルの一意の識別子（例：Mouse_A、CellLine_1）。
-   `group`: 実験グループまたは条件（例：Control_X、Treatment_Y）。
-   `gene`: 測定される遺伝子の名前（例：Gapdh、Actb）。
-   `Cq`: 定量サイクル値（数値）。**注:** この列の名前は`Cq`である必要があります。

各行は，1つのサンプルにおける1つの遺伝子のCq値を表す必要があります。テクニカルリプリケートがある場合，その平均値を計算して使用してください。テンプレートファイル（[Click-qPCR_template.csv](Click-qPCR_template.csv)）はアプリケーションのサイドバーからダウンロードできます。


## 使用方法

1.  **データのアップロード:**
    -   `Preprocessing and ΔCq Analysis`タブで，`Upload CSV File`または`Use Example Data`をクリックします。プレビューが表示されます。

2.  **ΔCq解析の実行:**
    -   `Enable multiple reference genes`にチェックを入れて，複数のリファレンス遺伝子を選択可能にします。
    -   `Reference Gene(s)`を選択します。
    -   1つ以上の`Target Gene(s)`を選択します。
    -   `Comparison Settings`で比較するグループのペアを定義します。`Add`をクリックして、さらに比較ペアを作成することも可能です。
    -   `Analyze`をクリックします。プロットと統計テーブルがメインパネルに表示されます。

3.  **ΔΔCq解析の実行:**
    -   `ΔΔCq Analysis`タブに移動します。
    -   リファレンス遺伝子はメインの解析から自動的に継承されます。
    -   単一の`Target Gene`を選択します。
    -   発現量の基準として扱われる`Base Group (Control)`を選択します。
    -   1つ以上の`Treatment Group(s)`を選択します。
    -   `Run ΔΔCq Analysis`をクリックします。フォールドチェンジのプロットとテーブルが表示されます。

4.  **ANOVAとDunnettの多重比較検定の実行:**
    -   `ΔCq ANOVA (Dunnett's post-hoc)`タブに移動します。
    -   単一の`Target Gene`を選択します。
    -   `Control Group`を選択します。
    -   2つ以上の`Treatment Group(s)`を選択します。
    -   `Run ANOVA`をクリックします。相対発現量のプロットと，ANOVAおよびDunnettの検定結果を含むテーブルが表示されます。
    -   `ΔΔCq ANOVA (Dunnett's post-hoc)`タブに移動すると，同じ結果がフォールドチェンジとして視覚化されます。

5.  **結果のダウンロード:**
    -   ダウンロードボタンを使用して結果を保存します。
    -   `Download Plot Settings`パネルを使用して，`Download Plot`ボタンの寸法と解像度をカスタマイズ可能です。（解像度はPNGのみ）


## サンプルデータを使用した解析例

このセクションでは，組み込みのサンプルデータを使用してアプリのコア機能を使用する方法を説明します。


### 1. サンプルデータの読み込みとΔCq解析の実行

まず，Welchの *t* 検定を使用して，2つのグループ間で単一遺伝子の発現を比較します。

* `Preprocessing and ΔCq Analysis`タブで，`Use Example Data`ボタンをクリックします。
* `Enable multiple reference genes`のチェックボックスをオンにします。
* `Reference Gene(s)`として`Gapdh`と`Actb`の両方を選択します。
* `Target Gene(s)`として`Hoge`のみが選択されていることを確認します。
* `Comparison Settings`で，`Control`と`Treatment_X`を比較するように設定します。
* 青い**`Analyze`**ボタンをクリックします。

#### **<ins>期待される出力</ins>**

棒グラフと解析をまとめたデータテーブルが表示されます。サンプルデータは`Treatment_X`グループの`Hoge`の発現が`Control`グループと比較して有意に低いことを示すように設計されています。

**プロット:** グラフには`Hoge`遺伝子に対する2つの棒が表示されます。1つは`Control`グループ用，もう1つは`Treatment_X`グループ用です。個々のデータポイントが棒の上に散りばめられ，`Treatment_X`の棒は`Control`の棒よりも著しく低くなります。有意性を示すブラケット（`***`）が2つの棒を結びます。

**統計テーブル:** プロットの下のテーブルには，ΔCq値に対して実行されたWelchの *t* 検定の結果が表示されます。

| gene | group1  | group2      | p_value  | sig |
| :--- | :------ | :---------- | :------- | :-- |
| Hoge | Control | Treatment_X | 1.25e-05 | *** |

---

### 2. ANOVAとDunnettの多重比較検定の実行

次に，単一のコントロールグループに対して，複数のトリートメントグループ間での1つの遺伝子を比較します。最初の`Preprocessing and ΔCq Analysis`タブで選択されたリファレンス遺伝子（`Gapdh`と`Actb`）は自動的に使用されます。

* `ΔCq ANOVA (Dunnett's post-hoc)`タブに移動します。
* `Target Gene`として`Hoge`を選択します。
* `Control Group`として`Control`を選択します。
* `Treatment Group(s)`ボックスで`Treatment_X`，`Treatment_Y`，および`Treatment_Z`を選択します。
* 青い**`Run ANOVA`**ボタンをクリックします。

#### **<ins>期待される出力</ins>**

この解析では，まず一元配置分散分析（one-way ANOVA）を実行して4つのグループ間に何らかの差があるかどうかを調べます。続いてDunnettの検定を実行して，各トリートメントグループをコントロールグループと特異的に比較します。サンプルデータは，すべてのトリートメントグループがコントロールと有意に異なることを示します。

**プロット:** グラフには，`Hoge`遺伝子に対する4つの棒が表示され，各グループ（`Control`，`Treatment_X`，`Treatment_Y`，`Treatment_Z`）に1つずつ対応します。各トリートメントグループを`Control`の棒と比較する有意性ブラケットが表示されます。

**統計テーブル:** テーブルには，まずANOVA *F* 検定の全体的な結果が表示されます。その下には，各トリートメント-コントロール比較に対するDunnettの検定の結果がリストされます。

| group1       | group2                               | p_value  | sig |
| :----------- | :----------------------------------- | :------- | :-- |
| ANOVA F-test | F(3, 12) = 59.39                     | 3.12e-08 |     |
| Control      | Treatment_X - Control = 0            | 2.11e-05 | *** |
| Control      | Treatment_Y - Control = 0            | 1.34e-03 | ** |
| Control      | Treatment_Z - Control = 0            | 2.00e-07 | *** |


## ライセンス

このプロジェクトはMITライセンスの下で公開されています。詳細はLICENSEファイルを参照してください。

## お問い合わせ

GitHub Discussionsをご利用いただくか，直接メールをお送りください。

