# WF5301 Workflow Files

This directory contains workflow files generated from the spreadsheet description of WF5301 using a [custom tool](https://github.com/Marco-Salvi/dt-geo-converter). These files provide an initial starting point, **manual verification and updates are required** to ensure accuracy.

## File Overview

- **\*.dot Files**  
  These are visual representations of the generated CWL files. Use [Graphviz](https://dreampuf.github.io/GraphvizOnline/) to render and review the workflow steps.

- **ST\*.cwl Files**  
  These files represent the CWL steps extracted from the spreadsheets. They reflect the provided data, but some details might be missing or the spreadsheets description might have had errors. **Action:** Review and complete the missing information.

- **WF\*.cwl File**  
  This is the main entry point of the workflow. It defines the global inputs, outputs, and the connections between the steps. A corresponding DOT file (wf\*.dot) is also available for visualization. **Action:** Review and complete the missing information.

- **ro-crate-metadata.json**  
  A metadata template generated from the CWL description. It should list all the entities in the workflow. **Action:** Manually compile any missing details. If the CWL files are incorrect, update this file to reflect the changes. 

## Detected Issues


No issues were detected during the conversion process.




## Next Steps

Carefully review the issues above and double-check the corresponding CWL files to ensure that all steps are correctly defined. Adjust any errors or omissions as necessary.

