---
title: Viralgenie
description: A metagenomics analysis pipeline for eukaryotic viruses written in nextflow
hide:
  - navigation
  - toc
---

# ![viralgenie](images/nf-core-viralgenie_logo_dark.png#only-dark)
# ![viralgenie](images/nf-core-viralgenie_logo_light.png#only-light)

{==

**A metagenomic analysis pipeline for eukaryotic viruses written in nextflow.**

==}

[![Nextflow](https://img.shields.io/badge/nextflow%20DSL2-%E2%89%A524.04.2-23aa62.svg)](https://www.nextflow.io/) [![run with conda](http://img.shields.io/badge/run%20with-conda-3EB049?labelColor=000000&logo=anaconda)](https://docs.conda.io/en/latest/) [![run with docker](https://img.shields.io/badge/run%20with-docker-0db7ed?labelColor=000000&logo=docker)](https://www.docker.com/) [![run with singularity](https://img.shields.io/badge/run%20with-singularity-1d355c.svg?labelColor=000000)](https://sylabs.io/docs/)
[![Launch on Seqera Platform](https://img.shields.io/badge/Launch%20%F0%9F%9A%80-Seqera%20Platform-%234256e7)](https://tower.nf/launch?pipeline=https://github.com/Joon-Klaps/viralgenie)

[![GitHub Actions CI Status](https://github.com/Joon-Klaps/viralgenie/actions/workflows/ci.yml/badge.svg)](https://github.com/Joon-Klaps/viralgenie/actions?query=workflow%3A%22nf-core+CI%22)
[![GitHub Actions Linting Status](https://github.com/Joon-Klaps/viralgenie/actions/workflows/linting.yml/badge.svg)](https://github.com/Joon-Klaps/viralgenie/actions?query=workflow%3A%22nf-core+linting%22)

<!-- [![Get help on Slack](http://img.shields.io/badge/slack-nf--core%20%23viralgenie-4A154B?labelColor=000000&logo=slack)](https://nfcore.slack.com/channels/viralgenie)-->

## Introduction

**Viralgenie** is a bioinformatics best-practice analysis pipeline for reconstructing consensus genomes and identifying intra-host variants from metagenomic sequencing data or enriched based sequencing data like hybrid capture.

## Pipeline summary

![viralgenie-workflow](images/metromap_style_pipeline_workflow_viralgenie.png)

--8<-- "README.md:31:"
