process BOWTIE2_ALIGN {
    tag "$meta.id"
    label 'process_high'

    input:
    tuple val(meta) , path(reads)
    file(index)
    val   save_unaligned
    val   save_aligned

    output:
    tuple val(meta), path("*.log")      , emit: log
    tuple val(meta), path("*fastq.gz")  , emit: fastq   , optional:true
    path  "versions.yml"                , emit: versions
    tuple val(meta), path("*unmapped*") , emit: unmapped_reads

    when:
    task.ext.when == null || task.ext.when

    script:
    def args = task.ext.args ?: ""
    def args2 = task.ext.args2 ?: ""
    def prefix = task.ext.prefix ?: "${meta.id}"

    def unaligned = ""
    def aligned = ""
    def reads_args = ""
    if (meta.single_end) {
        unaligned = save_unaligned ? "--un-gz ${prefix}.unmapped.fastq.gz" : ""
        aligned = save_aligned ? "--al-conc-gz ${prefix}.mapped.fastq.gz" : ""
        reads_args = "-U ${reads}"
    } else {
        unaligned = save_unaligned ? "--un-conc-gz ${prefix}.unmapped_%.fastq.gz" : ""
        aligned = save_aligned ? "--al-conc-gz ${prefix}.mapped_%.fastq.gz" : ""
        reads_args = "-1 ${reads[0]} -2 ${reads[1]}"
    }

    """
    INDEX=`find -L ./ -name "*.rev.1.bt2" | sed "s/\\.rev.1.bt2\$//"`
    [ -z "\$INDEX" ] && INDEX=`find -L ./ -name "*.rev.1.bt2l" | sed "s/\\.rev.1.bt2l\$//"`
    [ -z "\$INDEX" ] && echo "Bowtie2 index files not found" 1>&2 && exit 1

    bowtie2 \\
        -x \$INDEX \\
        $reads_args \\
        --threads $task.cpus \\
        $unaligned \\
        $aligned \\
        $args \\
        $args2 \\
        2> >(tee ${prefix}.bowtie2.log >&2)

    cat <<-END_VERSIONS > versions.yml
    "${task.process}":
        bowtie2: \$(echo \$(bowtie2 --version 2>&1) | sed 's/^.*bowtie2-align-s version //; s/ .*\$//')
    END_VERSIONS
    """

    // stub:
    // def args2 = task.ext.args2 ?: ""
    // def prefix = task.ext.prefix ?: "${meta.id}"
    // def extension_pattern = /(--output-fmt|-O)+\s+(\S+)/
    // def extension = (args2 ==~ extension_pattern) ? (args2 =~ extension_pattern)[0][2].toLowerCase() : "bam"
    // def create_unmapped = ""
    // if (meta.single_end) {
    //     create_unmapped = save_unaligned ? "touch ${prefix}.unmapped.fastq.gz" : ""
    // } else {
    //     create_unmapped = save_unaligned ? "touch ${prefix}.unmapped_1.fastq.gz && touch ${prefix}.unmapped_2.fastq.gz" : ""
    // }

    // """
    // touch ${prefix}.${extension}
    // touch ${prefix}.bowtie2.log
    // ${create_unmapped}

    // cat <<-END_VERSIONS > versions.yml
    // "${task.process}":
    //     bowtie2: \$(echo \$(bowtie2 --version 2>&1) | sed 's/^.*bowtie2-align-s version //; s/ .*\$//')
    //     samtools: \$(echo \$(samtools --version 2>&1) | sed 's/^.*samtools //; s/Using.*\$//')
    //     pigz: \$( pigz --version 2>&1 | sed 's/pigz //g' )
    // END_VERSIONS
    // """
}