#!/usr/bin/env python3
# -*- coding: utf-8 -*-

####################################################################################################
#
#    mOTUs profiling
#
####################################################################################################
tmpdir = os.path.join(working_dir, "tmp")

def input_cmd(wildcards):
    list_reads = []
    for run in reads2use[wildcards.sample]:
        list_reads.extend(reads2use[wildcards.sample][run])
    return list_reads

rule target_motus:
    output:
        os.path.join(tmpdir, "motus.checkpoint")
    input:
        os.path.join(working_dir, "motus_profiling/mOTU_table.tsv"),
    priority:5
    shell:
        "touch {output}"

rule merge_mOTUS:
    '''
        merge all profile in a single tab
    '''
    output:
        os.path.join(working_dir, "motus_profiling/mOTU_table.tsv")
    input:
         expand(os.path.join(working_dir, "motus_profiling/profiles/{sample}.motus"), sample=samples),
    conda:
        os.path.join(CONDAENV, "motus.yaml")
    params:
        motus = os.path.join(working_dir, "motus_profiling/profiles")
    priority:5
    shell:
        "motus merge -d {params.motus} -o {output}"

rule motus:
    """
        Every mOTU is composed of 10 marker genes
        see https://github.com/motu-tool/mOTUs_v2
    """
    output:
        os.path.join(working_dir, "motus_profiling/profiles/{sample}.motus")
    input:
        reads = input_cmd,
        dowload_db_ok = os.path.join(tmpdir, "motus_DB.checkpoint")
    conda:
        os.path.join(CONDAENV,"motus.yaml")
    params:
        cmd = lambda wildcards,input : cmdparser.cmd(wildcards.sample, input.reads, reads2use, "motus").cmd,
        aln_len = config["alignment_length"],
        ngene = config["gene#required"],
    log:
        os.path.join(working_dir, "logs/motus/{sample}.motus.log")
    threads:
        10
    priority:5
    shell:
        "motus profile "
        "{params.cmd} "
        "-n {wildcards.sample} "
        "-A  " #detailed taxonomy
        "-l {params.aln_len} " #minimum alignment length
        "-y insert.scaled_counts "  #read counts scaled by gene length
        "-g {params.ngene} " #number of mOTU gene to considered a mOTU present.
        "-t {threads} "
        "> {output} 2>{log}"

rule motus_download_db:
    """
    Download motus2 database.
    """
    output: temp(os.path.join(tmpdir, "motus_DB.checkpoint"))
    input: os.path.join(tmpdir, "QC.checkpoint")
    conda: os.path.join(CONDAENV,"motus.yaml")
    shell: "motus downloadDB && touch {output}"
