{
    "$graph": [
        {
            "class": "ExpressionTool",
            "doc": "Determines the final outputs of the reference file.",
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                }
            ],
            "inputs": [
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#determine_output.cwl/extracted_fasta"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#determine_output.cwl/fetched_reference"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#determine_output.cwl/merged_fasta"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#determine_output.cwl/merged_genbank"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#determine_output.cwl/original_reference"
                }
            ],
            "expression": "${\n  return {\n    genbank: inputs.merged_genbank || inputs.fetched_reference || inputs.original_reference,\n    fasta: inputs.merged_fasta || inputs.extracted_fasta || null\n  };\n}\n",
            "id": "#determine_output.cwl",
            "https://schema.org/author": [
                {
                    "class": "https://schema.org/Person",
                    "https://schema.org/identifier": "https://orcid.org/0009-0005-0017-0928",
                    "https://schema.org/email": "mailto:martijn.melissen@wur.nl",
                    "https://schema.org/name": "Martijn Melissen"
                }
            ],
            "https://schema.org/citation": "https://m-unlock.nl",
            "https://schema.org/codeRepository": "https://gitlab.com/m-unlock/cwl",
            "https://schema.org/dateCreated": "2025-04-17",
            "https://schema.org/dateModified": "2025-04-17",
            "https://schema.org/license": "https://spdx.org/licenses/Apache-2.0",
            "https://schema.org/copyrightHolder": "UNLOCK - Unlocking Microbial Potential",
            "outputs": [
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "id": "#determine_output.cwl/fasta"
                },
                {
                    "type": "File",
                    "id": "#determine_output.cwl/genbank"
                }
            ]
        },
        {
            "class": "CommandLineTool",
            "label": "custom GenBank downloading script",
            "doc": "A custom python script to download GenBank Files from accesion numbers.",
            "requirements": [
                {
                    "listing": [
                        {
                            "entryname": "staging_folder",
                            "writable": true,
                            "entry": "$(null)"
                        },
                        {
                            "entryname": "download_ncbi.sh",
                            "entry": "#!/bin/bash\nID=$1 # NCBI identifier          \necho \"Downloading genome $ID from NCBI\"\nwget \"https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=nucleotide&id=$ID&rettype=gbwithparts&retmode=text\" -O \"$ID.gb\""
                        }
                    ],
                    "class": "InitialWorkDirRequirement"
                },
                {
                    "class": "InlineJavascriptRequirement"
                }
            ],
            "baseCommand": [
                "bash",
                "download_ncbi.sh"
            ],
            "inputs": [
                {
                    "type": "string",
                    "label": "NCBI genome identifier",
                    "doc": "Required. NCBI accession number to download a GenBank file from.\n",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#download_genbank.cwl/accession_number"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "label": "downloaded GenBank File",
                    "doc": "The downloaded GenBank file.",
                    "outputBinding": {
                        "glob": "$(inputs.accession_number).gb"
                    },
                    "id": "#download_genbank.cwl/genbank_file"
                }
            ],
            "id": "#download_genbank.cwl",
            "https://schema.org/author": [
                {
                    "class": "https://schema.org/Person",
                    "https://schema.org/identifier": "https://orcid.org/0009-0005-0017-0928",
                    "https://schema.org/email": "mailto:martijn.melissen@wur.nl",
                    "https://schema.org/name": "Martijn Melissen"
                }
            ],
            "https://schema.org/citation": "https://m-unlock.nl",
            "https://schema.org/codeRepository": "https://git.wur.nl/ssb/automated-data-analysis",
            "https://schema.org/dateCreated": "2025-04-14",
            "https://schema.org/dateModified": "2025-04-14",
            "https://schema.org/license": "https://spdx.org/licenses/Apache-2.0",
            "https://schema.org/copyrightHolder": "UNLOCK - Unlocking Microbial Potential"
        },
        {
            "class": "CommandLineTool",
            "label": "custom GenBank to fasta extraction python script",
            "doc": "Uses a custom python script to extract a GenBank file.",
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                }
            ],
            "hints": [
                {
                    "dockerPull": "quay.io/biocontainers/biopython:1.69--np110py36_0",
                    "class": "DockerRequirement"
                },
                {
                    "packages": [
                        {
                            "version": [
                                "1.69"
                            ],
                            "specs": [
                                "file:///mnt/c/Users/melis031/Git/Unlock/ada/cwl/tools/scripts/identifiers.org/RRID:SCR_007173"
                            ],
                            "package": "biopython"
                        }
                    ],
                    "class": "SoftwareRequirement"
                }
            ],
            "baseCommand": [
                "python"
            ],
            "inputs": [
                {
                    "label": "GenBank file",
                    "doc": "Input GenBank file.",
                    "type": "File",
                    "inputBinding": {
                        "position": 2
                    },
                    "id": "#genbank_to_fasta.cwl/genbank_file"
                },
                {
                    "label": "output prefix",
                    "doc": "The prefix for the output FASTA file.",
                    "type": "string",
                    "inputBinding": {
                        "position": 3
                    },
                    "id": "#genbank_to_fasta.cwl/output_prefix"
                },
                {
                    "type": "File",
                    "label": "custom python script",
                    "doc": "The custom python script \"genbank_to_fasta.py\"",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#genbank_to_fasta.cwl/script"
                }
            ],
            "outputs": [
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "label": "extracted FASTA file",
                    "doc": "The extracted FASTA file.",
                    "outputBinding": {
                        "glob": "$(inputs.output_prefix).fasta"
                    },
                    "id": "#genbank_to_fasta.cwl/fasta"
                }
            ],
            "id": "#genbank_to_fasta.cwl",
            "https://schema.org/author": [
                {
                    "class": "https://schema.org/Person",
                    "https://schema.org/identifier": "https://orcid.org/0009-0005-0017-0928",
                    "https://schema.org/email": "mailto:martijn.melissen@wur.nl",
                    "https://schema.org/name": "Martijn Melissen"
                }
            ],
            "https://schema.org/citation": "https://m-unlock.nl",
            "https://schema.org/codeRepository": "https://git.wur.nl/ssb/automated-data-analysis",
            "https://schema.org/dateCreated": "2025-04-17",
            "https://schema.org/dateModified": "2025-04-17",
            "https://schema.org/license": "https://spdx.org/licenses/Apache-2.0",
            "https://schema.org/copyrightHolder": "UNLOCK - Unlocking Microbial Potential"
        },
        {
            "class": "CommandLineTool",
            "label": "GFF3 extraction Perl script",
            "doc": "Uses a BioPerl script to extract a GFF3 file from a GenBank file.",
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                }
            ],
            "hints": [
                {
                    "dockerPull": "quay.io/biocontainers/perl-bioperl-run:1.007002--pl526_3",
                    "class": "DockerRequirement"
                },
                {
                    "packages": [
                        {
                            "version": [
                                "1.007002"
                            ],
                            "specs": [
                                "file:///mnt/c/Users/melis031/Git/Unlock/ada/cwl/tools/scripts/identifiers.org/RRID:SCR_002989"
                            ],
                            "package": "bcbio-gff"
                        }
                    ],
                    "class": "SoftwareRequirement"
                }
            ],
            "baseCommand": [
                "perl"
            ],
            "inputs": [
                {
                    "label": "GenBank file",
                    "doc": "Input GenBank file.",
                    "type": "File",
                    "inputBinding": {
                        "position": 2
                    },
                    "id": "#genbank_to_gff3.cwl/genbank_file"
                },
                {
                    "type": "File",
                    "label": "Perl script",
                    "doc": "The Perl script \"bp_genbank2gff3_fixed.pl\".",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#genbank_to_gff3.cwl/script"
                }
            ],
            "outputs": [
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "label": "extracted GFF3 file",
                    "doc": "The extracted GFF3 file with proper extension.",
                    "outputBinding": {
                        "glob": "*.gff",
                        "outputEval": "${self[0].basename = self[0].basename.replace('.gb.gff', '.gff3'); return self}"
                    },
                    "id": "#genbank_to_gff3.cwl/gff3"
                }
            ],
            "id": "#genbank_to_gff3.cwl",
            "https://schema.org/author": [
                {
                    "class": "https://schema.org/Person",
                    "https://schema.org/identifier": "https://orcid.org/0009-0005-0017-0928",
                    "https://schema.org/email": "mailto:martijn.melissen@wur.nl",
                    "https://schema.org/name": "Martijn Melissen"
                }
            ],
            "https://schema.org/citation": "https://m-unlock.nl",
            "https://schema.org/codeRepository": "https://git.wur.nl/ssb/automated-data-analysis",
            "https://schema.org/dateCreated": "2025-05-06",
            "https://schema.org/dateModified": "2025-05-06",
            "https://schema.org/license": "https://spdx.org/licenses/Apache-2.0",
            "https://schema.org/copyrightHolder": "UNLOCK - Unlocking Microbial Potential"
        },
        {
            "class": "CommandLineTool",
            "label": "custom GenBank merging python script",
            "doc": "A custom python script to merge multiple GenBank files, optionally also outputs a FASTA file.",
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                }
            ],
            "hints": [
                {
                    "dockerPull": "quay.io/biocontainers/biopython:1.69--np110py36_0",
                    "class": "DockerRequirement"
                },
                {
                    "packages": [
                        {
                            "version": [
                                "1.69"
                            ],
                            "specs": [
                                "file:///mnt/c/Users/melis031/Git/Unlock/ada/cwl/tools/scripts/identifiers.org/RRID:SCR_007173"
                            ],
                            "package": "biopython"
                        }
                    ],
                    "class": "SoftwareRequirement"
                }
            ],
            "baseCommand": [
                "python"
            ],
            "inputs": [
                {
                    "label": "FASTA output",
                    "doc": "Optional flag to output a FASTA file in addition.",
                    "type": "boolean",
                    "inputBinding": {
                        "prefix": "--fasta",
                        "position": 4
                    },
                    "default": false,
                    "id": "#merge_genbank.cwl/fasta_output"
                },
                {
                    "label": "GenBank files",
                    "doc": "List of input GenBank files to be merged.",
                    "type": {
                        "type": "array",
                        "items": "File"
                    },
                    "inputBinding": {
                        "position": 2
                    },
                    "id": "#merge_genbank.cwl/genbank_files"
                },
                {
                    "label": "output prefix",
                    "doc": "The prefix for the output merged GenBank and FASTA files.",
                    "type": "string",
                    "inputBinding": {
                        "position": 3
                    },
                    "id": "#merge_genbank.cwl/output_prefix"
                },
                {
                    "type": "File",
                    "label": "custom python script",
                    "doc": "The custom python script \"merge_genbank.py\".",
                    "inputBinding": {
                        "position": 1
                    },
                    "id": "#merge_genbank.cwl/script"
                }
            ],
            "outputs": [
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "label": "merged FASTA file",
                    "doc": "Merged FASTA file (optional, based on fasta_output flag).",
                    "outputBinding": {
                        "glob": "$(inputs.output_prefix).fasta"
                    },
                    "id": "#merge_genbank.cwl/merged_fasta"
                },
                {
                    "type": "File",
                    "label": "merged GenBank File",
                    "doc": "Merged GenBank file.",
                    "outputBinding": {
                        "glob": "$(inputs.output_prefix).gb"
                    },
                    "id": "#merge_genbank.cwl/merged_genbank"
                }
            ],
            "id": "#merge_genbank.cwl",
            "https://schema.org/author": [
                {
                    "class": "https://schema.org/Person",
                    "https://schema.org/identifier": "https://orcid.org/0009-0005-0017-0928",
                    "https://schema.org/email": "mailto:martijn.melissen@wur.nl",
                    "https://schema.org/name": "Martijn Melissen"
                }
            ],
            "https://schema.org/citation": "https://m-unlock.nl",
            "https://schema.org/codeRepository": "https://git.wur.nl/ssb/automated-data-analysis",
            "https://schema.org/dateCreated": "2025-04-14",
            "https://schema.org/dateModified": "2025-04-14",
            "https://schema.org/license": "https://spdx.org/licenses/Apache-2.0",
            "https://schema.org/copyrightHolder": "UNLOCK - Unlocking Microbial Potential"
        },
        {
            "class": "Workflow",
            "requirements": [
                {
                    "class": "InlineJavascriptRequirement"
                },
                {
                    "class": "MultipleInputFeatureRequirement"
                },
                {
                    "class": "StepInputExpressionRequirement"
                }
            ],
            "label": "plasmid preprocessing workflow",
            "doc": "**Workflow for preprocessing the reference file. Downloads the GenBank file from NCBI if not provided, concatenates plasmid GenBank file(s) with each other and the reference file.**\n\nThis workflow on WorkflowHub: https://workflowhub.eu/projects/upcoming\n\n**All tool CWL files and other workflows can be found here:**\n  Tools: https://git.wur.nl/ssb/automated-data-analysis/cwl/-/tree/main/tools\n  Workflows: https://git.wur.nl/ssb/automated-data-analysis/cwl/-/tree/main/workflows\n",
            "inputs": [
                {
                    "type": [
                        "null",
                        "string"
                    ],
                    "label": "accession number",
                    "doc": "accession number, used to download a GenBank file from NCBI, mandatory when not inputting a reference file.",
                    "id": "#main/accession_number"
                },
                {
                    "type": "File",
                    "label": "FASTA extraction script",
                    "doc": "Python script that extracts a FASTA file from GenBank Files. Passed externally within the git structure to avoid having to host a new image.",
                    "default": {
                        "class": "File",
                        "location": "file:///mnt/c/Users/melis031/Git/Unlock/ada/cwl/tools/scripts/genbank_to_fasta.py",
                        "basename": "genbank_to_fasta.py"
                    },
                    "id": "#main/fasta_extraction_script"
                },
                {
                    "type": "File",
                    "label": "GFF3 extraction script",
                    "doc": "BioPerl script that extracts a GFF3 file from GenBank Files. Passed externally within the git structure to avoid having to host a new image.",
                    "default": {
                        "class": "File",
                        "location": "file:///mnt/c/Users/melis031/Git/Unlock/ada/cwl/tools/scripts/bp_genbank2gff3_fixed.pl",
                        "basename": "bp_genbank2gff3_fixed.pl"
                    },
                    "id": "#main/gff3_extraction_script"
                },
                {
                    "type": "File",
                    "label": "merging script",
                    "doc": "Python script to merge multiple GenBank Files. Passed externally within the git structure to avoid having to host a new image.",
                    "default": {
                        "class": "File",
                        "location": "file:///mnt/c/Users/melis031/Git/Unlock/ada/cwl/tools/scripts/merge_genbank.py",
                        "basename": "merge_genbank.py"
                    },
                    "id": "#main/merging_genbank_script"
                },
                {
                    "type": [
                        "null",
                        {
                            "type": "array",
                            "items": "File"
                        }
                    ],
                    "label": "plasmid file(s)",
                    "doc": "Input plasmid GenBank files.",
                    "id": "#main/plasmids"
                },
                {
                    "type": [
                        "null",
                        "File"
                    ],
                    "label": "reference GenBank file",
                    "doc": "Reference file in GenBank format.",
                    "id": "#main/reference_file"
                }
            ],
            "steps": [
                {
                    "label": "determine output",
                    "doc": "Determines relevant final outputs.",
                    "run": "#determine_output.cwl",
                    "in": [
                        {
                            "source": "#main/extract_fasta/fasta",
                            "id": "#main/determine_output/extracted_fasta"
                        },
                        {
                            "source": "#main/fetch_reference/genbank_file",
                            "id": "#main/determine_output/fetched_reference"
                        },
                        {
                            "source": "#main/merge_reference/merged_fasta",
                            "id": "#main/determine_output/merged_fasta"
                        },
                        {
                            "source": "#main/merge_reference/merged_genbank",
                            "id": "#main/determine_output/merged_genbank"
                        },
                        {
                            "source": "#main/reference_file",
                            "id": "#main/determine_output/original_reference"
                        }
                    ],
                    "out": [
                        "#main/determine_output/genbank",
                        "#main/determine_output/fasta"
                    ],
                    "id": "#main/determine_output"
                },
                {
                    "label": "extract FASTA",
                    "doc": "Extracts FASTA file from input reference file when no plasmids are provided.",
                    "run": "#genbank_to_fasta.cwl",
                    "when": "$(inputs.plasmids == null)",
                    "in": [
                        {
                            "source": [
                                "#main/fetch_reference/genbank_file",
                                "#main/reference_file"
                            ],
                            "pickValue": "first_non_null",
                            "id": "#main/extract_fasta/genbank_file"
                        },
                        {
                            "valueFrom": "extracted",
                            "id": "#main/extract_fasta/output_prefix"
                        },
                        {
                            "source": "#main/plasmids",
                            "id": "#main/extract_fasta/plasmids"
                        },
                        {
                            "source": "#main/reference_file",
                            "id": "#main/extract_fasta/reference_file"
                        },
                        {
                            "source": "#main/fasta_extraction_script",
                            "id": "#main/extract_fasta/script"
                        }
                    ],
                    "out": [
                        "#main/extract_fasta/fasta"
                    ],
                    "id": "#main/extract_fasta"
                },
                {
                    "label": "extract GFF3",
                    "doc": "Extracts GFF3 annotation file from the (merged) reference.",
                    "run": "#genbank_to_gff3.cwl",
                    "in": [
                        {
                            "source": [
                                "#main/merge_reference/merged_genbank",
                                "#main/fetch_reference/genbank_file",
                                "#main/reference_file"
                            ],
                            "pickValue": "first_non_null",
                            "id": "#main/extract_gff3/genbank_file"
                        },
                        {
                            "source": "#main/gff3_extraction_script",
                            "id": "#main/extract_gff3/script"
                        }
                    ],
                    "out": [
                        "#main/extract_gff3/gff3"
                    ],
                    "id": "#main/extract_gff3"
                },
                {
                    "label": "fetch reference",
                    "doc": "Downloads the associated GenBank file from the supplied accession number.",
                    "run": "#download_genbank.cwl",
                    "when": "$(inputs.accession_number !== null && inputs.reference_file === null)",
                    "in": [
                        {
                            "source": "#main/accession_number",
                            "id": "#main/fetch_reference/accession_number"
                        },
                        {
                            "source": "#main/reference_file",
                            "id": "#main/fetch_reference/reference_file"
                        }
                    ],
                    "out": [
                        "#main/fetch_reference/genbank_file"
                    ],
                    "id": "#main/fetch_reference"
                },
                {
                    "label": "merge plasmids",
                    "doc": "Merges plasmids when more than one are present.",
                    "run": "#merge_genbank.cwl",
                    "when": "$(inputs.plasmids !== null && inputs.plasmids.contents !== \"\" && inputs.plasmids.length > 1)",
                    "in": [
                        {
                            "source": "#main/plasmids",
                            "id": "#main/merge_plasmids/genbank_files"
                        },
                        {
                            "valueFrom": "merged_plasmids",
                            "id": "#main/merge_plasmids/output_prefix"
                        },
                        {
                            "source": "#main/plasmids",
                            "id": "#main/merge_plasmids/plasmids"
                        },
                        {
                            "source": "#main/merging_genbank_script",
                            "id": "#main/merge_plasmids/script"
                        }
                    ],
                    "out": [
                        "#main/merge_plasmids/merged_genbank"
                    ],
                    "id": "#main/merge_plasmids"
                },
                {
                    "label": "merge plasmid(s) with reference",
                    "doc": "Merges the plasmid(s) with the reference GenBank file.",
                    "run": "#merge_genbank.cwl",
                    "when": "$(inputs.plasmids !== null && inputs.plasmids.contents !== \"\")",
                    "in": [
                        {
                            "valueFrom": "$(true)",
                            "id": "#main/merge_reference/fasta_output"
                        },
                        {
                            "source": "#main/fetch_reference/genbank_file",
                            "id": "#main/merge_reference/fetched_reference"
                        },
                        {
                            "valueFrom": "${\n  var gb_list = [];\n  if (inputs.reference_file) {\n    gb_list.push(inputs.reference_file);\n  } else if (inputs.fetched_reference) {\n    gb_list.push(inputs.fetched_reference);\n  }\n  if (inputs.plasmids && inputs.plasmids.length > 1) {\n    gb_list.push(inputs.merged_plasmids);\n  } else if (inputs.plasmids) {\n    gb_list.push(inputs.plasmids[0]);\n  }\n  return gb_list;\n}\n",
                            "id": "#main/merge_reference/genbank_files"
                        },
                        {
                            "source": "#main/merge_plasmids/merged_genbank",
                            "id": "#main/merge_reference/merged_plasmids"
                        },
                        {
                            "valueFrom": "merged_reference",
                            "id": "#main/merge_reference/output_prefix"
                        },
                        {
                            "source": "#main/plasmids",
                            "id": "#main/merge_reference/plasmids"
                        },
                        {
                            "source": "#main/reference_file",
                            "id": "#main/merge_reference/reference_file"
                        },
                        {
                            "source": "#main/merging_genbank_script",
                            "id": "#main/merge_reference/script"
                        }
                    ],
                    "out": [
                        "#main/merge_reference/merged_genbank",
                        "#main/merge_reference/merged_fasta"
                    ],
                    "id": "#main/merge_reference"
                }
            ],
            "outputs": [
                {
                    "type": "File",
                    "label": "FASTA output file",
                    "doc": "Final FASTA output file.",
                    "outputSource": "#main/determine_output/fasta",
                    "id": "#main/fasta_final"
                },
                {
                    "type": "File",
                    "label": "GenBank output file",
                    "doc": "Final GenBank output file.",
                    "outputSource": "#main/determine_output/genbank",
                    "id": "#main/genbank_final"
                },
                {
                    "type": "File",
                    "label": "GFF3 output file",
                    "doc": "Final GFF3 output file.",
                    "outputSource": "#main/extract_gff3/gff3",
                    "id": "#main/gff3"
                }
            ],
            "id": "#main",
            "https://schema.org/author": [
                {
                    "class": "https://schema.org/Person",
                    "https://schema.org/identifier": "https://orcid.org/0009-0005-0017-0928",
                    "https://schema.org/email": "mailto:martijn.melissen@wur.nl",
                    "https://schema.org/name": "Martijn Melissen"
                }
            ],
            "https://schema.org/citation": "placeholder",
            "https://schema.org/codeRepository": "https://git.wur.nl/ssb/automated-data-analysis/cwl",
            "https://schema.org/dateCreated": "2025-04-14",
            "https://schema.org/dateModified": "2025-06-20",
            "https://schema.org/license": "https://spdx.org/licenses/Apache-2.0",
            "https://schema.org/copyrightHolder": "placeholder"
        }
    ],
    "cwlVersion": "v1.2",
    "$namespaces": {
        "s": "https://schema.org/"
    }
}
