This document includes a detailed description of the files in Results archive. 
For better understanding, we separated files at each iteration of the workflow.
To retrieve all the results, files resulting from only last iteration are sufficient.

Directory structure in this archive is as follows:

#############################################################
##                                                         ##
##   Results Archive                                       ##
##   │                                                     ##
##   │───CroMaSt_Cadherin_run001                           ##
##   │     │─Iteration1                                    ##
##   │     │─Iteration2                                    ##
##   │     └─CroMaSt_input.yml                             ##
##   │                                                     ##
##   │───CroMaSt_RRM_run001                                ##
##   │     │─Iteration1                                    ##
##   │     │─Iteration2                                    ##
##   │     └─CroMaSt_input.yml                             ##
##   │                                                     ##
##   │───CroMaSt_RRM_run002                                ##
##   │     │─Iteration1                                    ##
##   │     │─Iteration2                                    ##
##   │     └─CroMaSt_input.yml                             ##
##   │                                                     ##
##   └───CroMaSt_Zinc_run001                               ##
##         │─Iteration1                                    ##
##         │─Iteration2                                    ##
##         └─CroMaSt_input.yml                             ##
##                                                         ##
#############################################################

Each directory is dedicated to a separate run of CroMaSt workflow for a given domain type.
For example: `CroMaSt_RRM_run001` contains the results from CroMaSt run1 for RRM domain type.

Each of these directories contain multiple subdirectories for each iteration, i.e. number of subdirectories depends on the number of iteration, and an input file named `CroMaSt_input.yml` to start the first iteration of CroMaSt workflow for the given domain type. 

The `Iteration1` and `Iteration2` directories contain the results from first and second iteration, respectively.

Each `IterationX` directory contain the following files, depending on how the workflow proceeds:

1. `align_Struct_analysis.csv` : This file contains the structural alignment results of unmapped structural instances (StIs) from Pfam
2. `cath_crossMapped_pfam.jsonx` : This file contains the StIs from CATH that are crossmapped to Pfam
3. `cath_lost_resmap_domain_StIs.json` : This file contains obsolete and inconsistent StIs from CATH (lost during residue mapping procedure)
4. `cath_resmapped_domains_StIs.csv` : This file contains the residue mapped domain StIs from Pfam
5. `cath_unmapped_failed_structs.csv` : This file contains the unmapped StIs from CATH those did not pass the given threshold
6. `cath_unmapped_passed_structs.csv` : This file contains the unmapped StIs from CATH those pass the given threshold (Domain-like)
7. `cath_unq_unmapped.jsonx` : This file contains the total unmapped StIs from CATH
8. `core_avgStruct.pdb`: This is the core average structure computed for given domain type, here RRM
9. `coreDomains.json` : This file contains the list of core domain StIs (used to computed the core average structure)
10. `crossmapped_cath_passed.json`: This file contains the StIs from CATH that are crossmapped to Pfam and passed the given threshold
11. `crossmapped_pfam_passed.json` : This file contains the StIs from Pfam that are crossmapped to CATH and passed the given threshold
12. `domain_like_structures.json` : This file contains all the domain like StIs 
13. `failed_domains_list.json` : This file contains all the failed domain StIs
14. `family_ids.json` : This file contains all the family identifiers that corresponds to given domain type
15. `new_param.yml` : This file contains the parameters for the next iteration
16. `*_avgStruct.pdb` : Files ending with "_avgStruct.pdb" are the average structures at the family level
17. `pfam_crossMapped_cath.jsonx` : This file contains the StIs from Pfam that are crossmapped to CATH
18. `pfam_lost_resmap_domain_StIs.json`: This file contains obsolete and inconsistent StIs from Pfam (lost during residue mapping procedure)
19. `pfam_unmapped_failed_structs.csv` : This file contains the unmapped StIs from Pfam those did not pass the given threshold
20. `pfam_unmapped_passed_structs.csv` : This file contains the unmapped StIs from Pfam those pass the given threshold (Domain-like)
21. `pfam_unq_unmapped.jsonx` : This file contains the total unmapped StIs from Pfam
22. `pfam_resmapped_domains_StIs.csv` : This file contains the residue mapped domain StIs from Pfam
23. `true_domains.json` : This file contains the list of true domain StIs
