---
order: 1
---

# Welcome

These pages are a tutorial workshop for the [Nextflow](https://www.nextflow.io) pipeline [nf-core/rnaseq](https://nf-co.re/rnaseq).

In this workshop, we will recap the application of next generation sequencing to identify differentially expressed genes.
You will learn how to use the rnaseq pipeline to carry out this data-intensive workflow efficiently.
We will cover topics such as configuration of the pipeline, code execution and data interpretation.

Please note that this is not an introductory workshop, and we will assume some basic familiarity with Nextflow.

By the end of this workshop, you will be able to:

- analyse simple NGS datasets with the nf-core/rnaseq workflow
- understand the key concepts behind RNAseq differential expression analysis
- customise some of its features for your own analyses
- integrate different sources of information to interpret the results

Let's get started!

## Running with Gitpod

In order to run this using GitPod, please make sure:

1. You have a GitHub account: if not, create one [here](https://github.com/signup)
2. Once you have a GitHub account, sign up for GitPod using your GitHub user [here](https://gitpod.io/login/) choosing "continue with GitHub".

Now you're all set and can use the following button to launch the service:

[![Open in GitPod](https://img.shields.io/badge/Gitpod-%20Open%20in%20Gitpod-908a85?logo=gitpod)](https://gitpod.io/#https://github.com/lescai-teaching/rnaseq-tutorial)

## Additional documentation

- You can find detailed documentation on **Nextflow** [here](https://www.nextflow.io/docs/latest/)
- You can find additional training on [these pages](https://training.nextflow.io)

## Credits & Copyright

This training material has been written and completed by [Lorenzo Sola](https://github.com/LorenzoS96), [Francesco Lescai](https://github.com/lescai), and [Mariangela Santorsola](https://github.com/msantorsola) during the [nf-core](https://nf-co.re) Hackathon in Barcellona, 2024.
Thank you to [Victoria Cepeda](https://github.com/vcepeda) for her contributions to the tutorial's revision.
The tutorial is aimed at anyone who is interested in using nf-core pipelines for their studies or research activities.

The Docker image and Gitpod environment used in this repository have been created by [Seqera](https://seqera.io) but have been made open-source ([CC BY-NC-ND](https://creativecommons.org/licenses/by-nc-nd/4.0/)) for the community.

All examples and descriptions are licensed under the [Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License](http://creativecommons.org/licenses/by-nc-nd/4.0/).
