[workflow name]
===========

  - [Description](#description)
  - [Diagram](#diagram)
  - [User guide](#user-guide)
      - [Quick start guide](#quick-start-guide)
      - [Infrastructure usage and
        recommendations](#infrastructure-usage-and-recommendations)
      - [Compute resource usage across tested
        infrastructures](#compute-resource-usage-across-tested-infrastructures)
  - [Benchmarking](#benchmarking)
  - [Workflow summaries](#workflow-summaries)
      - [Metadata](#metadata)
      - [Component tools](#component-tools)
      - [Required (minimum)
        inputs/parameters](#required-minimum-inputsparameters)
  - [Additional notes](#additional-notes)
  - [Help/FAQ/Troubleshooting](#helpfaqtroubleshooting)
  - [3rd party Tutorials](#3rd-party-tutorials)
  - [Licence(s)](#licences)
  - [Acknowledgements/citations/credits](#acknowledgementscitationscredits)

---

# Description

```
Introduction of workflow and its component tools.

Table with embedded registry links.
```

---

# Diagram

```
Logical visual description of processing steps for workflow
```

---

# User guide

## Quick start guide

```
General guide for deployment across multiple infrastructures (distinct from specific infrastructure quick start guide) 
```

---

## Infrastructure usage and recommendations

```
+ link to installation instructions for each infrastructure 
+ recommendations
    
Documentation for a specific infrastructure should go into a infrastructure documentation template
https://github.com/AustralianBioCommons/doc_guidelines/blob/master/infrastructure_optimisation.md
```

---

## Compute resource usage across tested infrastructures

```
Table with high level compute resource usage information for standalone runs or testing of specific versions on specific computational infrastructures.
```

| Title | Version | Sample description | Wall time | Cores | Peak RAM in GB (requested) | Drive (GB) | HPC-HTC | If HPC-HTC is other, specify | Scheduler | Year-Month |
| ----- | ------- | ------------------ | --------- | ----- | -------------------------- | ---------- | ------- | ---------------------------- | --------- | ---------- |
|       |         |                    |           |       |                            |            |         |                              |           |            |

---

# Benchmarking

```
Benchmarking for a specific infrastructure should go here: if this document is complicated it should go into a benchmarking template, or be provided elsewhere (e.g. Zenodo). 
```

---

# Workflow summaries

## Metadata

```
Example table below 
```

|metadata field     | workflow_name / workflow_version  |
|-------------------|:---------------------------------:|
|Version            | workflow_version                  |
|Maturity           | stable                            |
|Creators           | workflow_author_1                 |
|Source             | NA                                |
|License            | NA                                |
|Workflow manager   | NextFlow                          |
|Container          | None                              |
|Install method     | Manual                            |
|GitHub             | NA                                |
|bio.tools 	        | NA                                |
|BioContainers      | NA                                | 
|bioconda           | NA                                |

---

## Component tools

```
Example below 
```
| Workflow element/tool name | Workflow element/tool version | Workflow element/tool dependencies | Workflow title |
|--------------------------|-----------------------------|----------------------------------|----------------|
|Tool 1                    |See workflow version         |Dependency/version                |workflow_title  |
|Tool 2                    |See workflow version         |Dependency/version                |workflow_title  |
|Tool 3                    |See workflow version         |Dependency/version                |workflow_title  |
---

## Required (minimum) inputs/parameters

```
The minimum inputs required for the workflow to run.
```

---

# Additional notes

---

# Help / FAQ / Troubleshooting

---

# 3rd party Tutorials 

---

# License(s)

---

# Acknowledgements/citations/credits

```
Any attribution information that is relevant to the workflow being documented.
```

---
