from pycompss.api.task import task
from pycompss.api.binary import binary
from pycompss.api.parameter import *
from pycompss.api.api import compss_barrier
from pycompss.api.api import compss_wait_on, compss_open
import os
import time



@task(file_list=COLLECTION_FILE_OUT)
def data_generation(n_files, file_list):
    """Generate a set of files.

    :param n_files: Number of files.
    :param file_list: File names to be generated.
    :return: None
    """
    time.sleep(60)
    for out_file in file_list:
        text_file = open(out_file, "w")
        text_file.write(str(1))
        text_file.close()


@binary(binary=str(os.path.join(os.getcwd(), "src/my_sim")))
@task(file_name_in=FILE_IN, file_name_out=FILE_OUT)
def my_simu(file_name_in, file_name_out):
    """Run simulation using an input file and producing an output file.

    Usage "my_sim f1 f1.out"

    :param file_name_in: Simulation input file.
    :param file_name_out: Simulation output file.
    :return: None
    """
    pass


@binary(binary=str(os.path.join(os.getcwd(),"src/my_analytic")))
@task(result=FILE_OUT, varargs_type=FILE_IN)
def my_analy(result, *fi):
    """Run analytic for a set of input files.

    :param fi: Set of files to be analyzed.
    :return: None
    """
    pass

@task(in_file=FILE_IN, returns=1)
def get_result(in_file, n, m):
   f=open(in_file)
   data = f.readlines()
   return (int(data[1])*n*m)

def my_w (i, j):
    file_collection = ['file_1_'+str(i)+str(j), 'file_2_'+str(i)+str(j), 'file_3_'+str(i)+str(j)]
    file_collection_out = []
    data_generation(3, file_collection)
    for fi in file_collection:
        fo = fi+".out"
        my_simu(fi, fo)
        file_collection_out.append(fo)
  
    analytic_output = "analytic_"+str(i)+str(j)+".out"
    my_analy(analytic_output, *file_collection_out)
    
    return(get_result(analytic_output, i, j))

def main():
    file_collection = ["file_1", "file_2", "file_3"]
    file_collection_out = []

    data_generation(3, file_collection)

    for fi in file_collection:
        fo = fi + ".out"
        my_simu(fi, fo)
        file_collection_out.append(fo)


    analytic_output = "analytic.out"
    my_analy(analytic_output, *file_collection_out)
    
    i=1
    j=2 
    result = get_result(analytic_output, i, j)
    result = compss_wait_on(result)
    print ("max value ", result)

    compss_barrier()


if __name__ == "__main__":
    main()
