# Genome Assembly from Hifi reads with HiC phasing - VGP4

Generate phased assembly based on PacBio Hifi Reads using HiC data from the same individual for assembly phasing. Part of the VGP workflow suite, it needs to be run after the k-mer profiling workflow VGP1.

## Inputs

1. Hifi long reads [fastq].
2. Trim Hi-C reads ? If yes, trim 5 bases at the beginning of each reads. Use with some Arima Hi-C data if the contact map looks "noisy". 
3. Collection of Hi-C forward reads [fastq].
4. Collection of Hi-C reverse reads [fastq].
5. Genome profile summary generated by Genomescope [txt] generated by VGP1 workflow.
6. K-mer database [meryldb] generated by VGP1 workflow.
7. Database to use for Busco lineages. Recommended : latest version.
8. Lineage. Select the taxonomic lineage of the assembled species.  
9. Name of first assembly.
10. Name of second assembly.
11. Bits for bloom filter. Change for large genomes to save memory.
12. Homozygous Read Coverage. Optional: specify if the coverage detected by Genomescope in VGP1 in not satisfactory.
13. Genomescope model parameters [tabular] generated by VGP1 workflow.

## Outputs

1. Haplotype 1 assembly ([fasta] and [gfa])
2. Haplotype 2 assembly ([fasta] and [gfa])
3. Trimmed Hi-C forward reads collection
4. Trimmed Hi-C reverse reads collection
5. QC: MultiQC report for HiFi reads trimming
6. QC: BUSCO report for both assemblies
7. QC: Merqury report for both assemblies
8. QC: Assembly statistics for both assemblies
9. QC: Nx plot for both assemblies
10. QC: Size plot for both assemblies
