# Genome Assembly with Hifi reads and Trio Data

Generate phased assembly based on PacBio Hifi Reads using parental Illumina data for phasing. Part of the VGP workflow suite, it needs to be run after the Trio k-mer Profiling workflow VGP2.

## Inputs

1. Hifi long reads [fastq]
2. Concatenated Illumina reads : Paternal [fastq]
3. Concatenated Illumina reads : Maternal [fastq]
4. K-mer database [meryldb] generated by VGP2 workflow.
5. Paternal hapmer database [meryldb] generated by VGP2 workflow.
6. Maternal hapmer database [meryldb] generated by VGP2 workflow.
7. Bits for Bloom Filter. Change for large genomes to save memory.
8. Database to use for Busco lineages. Recommended : latest version.
8. Lineage. Select the taxonomic lineage of the assembled species.  
9.  Homozygous read coverage (Estimated from the Genomescope model if not provided)
10. Genome model parameters generated by Genomescope [tabular] generated by VGP2 workflow.
11. Genome profile summary generated by Genomescope [txt] generated by VGP2 workflow.
12. Name of first haplotype
13. Name of second haplotype

## Outputs

1. Haplotype 1 assembly [fasta] and [gfa]
2. Haplotype 2 assembly [fasta] and [gfa]
9. QC: Size plot for both assemblies
5. QC: MultiQC report for HiFi reads trimming
6. QC: BUSCO report for both assemblies
7. QC: Compleasm report for both assemblies
8. QC: Merqury report for both assemblies
9. QC: Assembly statistics for both assemblies
10. QC: Nx plot for both assemblies
11. QC: Size plot for both assemblies

