import numpy as np
import dislib as ds
from pycompss.api.api import compss_barrier, compss_wait_on
from time import time
from dislib.decomposition import lanczos_svd
import math
from sklearn.datasets import make_low_rank_matrix
from os import listdir
from os.path import isfile, join


def create_matrix(m, n):
    # Define the range of exponents for the singular values
    min_exp = -14
    max_exp = 3

    # Generate a set of logarithmically spaced singular values between 10^min_exp and 10^max_exp
    singular_values = np.logspace(min_exp, max_exp, num=min(m, n))

    # Generate a matrix with shape (m, n)
    A = np.zeros((m, n))

    # Set the singular values of A
    np.fill_diagonal(A, singular_values)

    # Apply the SVD to A to ensure that it has the correct singular values
    U, s, Vt = np.linalg.svd(A, full_matrices=False)
    A = U.dot(np.diag(s)).dot(Vt)

    return A, singular_values[::-1]


def main():
    A, sing_values = create_matrix(50000, 150)
    A = ds.array(A, block_size=(50000, 20))
    u, s, v = lanczos_svd(A, k=40, bs=20, rank=20, num_sv=15, tolerance=1e-3, epsilon=1e-3, max_num_iterations=1)
    s = s.collect()
    print("Singular values computed: " + str(s), flush=True)

if __name__ == '__main__':
    main()
