import time
import sys
from pycompss.api.api import compss_wait_on
from pycompss.api.task import task

# Mark 'increment' as a COMPSs task
@task(returns=int)
def increment(value):
    time.sleep(2)
    return value + 1

# Mark 'fibonacci' as a COMPSs task
@task(returns=int)
def fibonacci(n):
        if n < 2:
            return n
        else:
            time.sleep(0.5) # Simulate some computation
            return fibonacci(n-1) + fibonacci(n-2)

# Main Function
def main():
    if len(sys.argv) > 1:
        values = [int(x) for x in sys.argv[1:]]
    else:
        values = [1, 2, 3, 4]
    print("Values before Incrementation:", values)
    start_time = time.time()
    newvalues = [0] * len(values)

    # Using COMPSs to increment twice
    for i, value in enumerate(values):
        for _ in range(2):
            value = increment(value)
        newvalues[i] = value

    # Wait for all the tasks to complete
    newvalues = compss_wait_on(newvalues)
    assert newvalues == [x + 2 for x in values]

    # Calculate Fibonacci numbers using COMPSs tasks
    fibovalues = [fibonacci(b) for b in range(7)]
    fibovalues = compss_wait_on(fibovalues) # Ensure tasks complete

    print("Values after Incrementatoin:", newvalues)
    print("Fibonacci Series:", fibovalues)
    print("Time Taken: " + str(time.time() - start_time))

if __name__ == '__main__':
    main()

