/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SchemaException
extends RuntimeException {
    private static final long serialVersionUID = 5987489689035036987L;
    private final String schemaLocation;

    private static Object typeOfValue(Object actualValue) {
        return actualValue == null ? "null" : actualValue.getClass().getSimpleName();
    }

    static String buildMessage(String pointer, Class<?> actualType, Class<?> expectedType, Class<?> ... furtherExpectedTypes) {
        Objects.requireNonNull(pointer, "pointer cannot be null");
        String actualTypeDescr = SchemaException.actualTypeDescr(actualType);
        if (furtherExpectedTypes != null && furtherExpectedTypes.length > 0) {
            Class[] allExpecteds = new Class[furtherExpectedTypes.length + 1];
            allExpecteds[0] = expectedType;
            System.arraycopy(furtherExpectedTypes, 0, allExpecteds, 1, furtherExpectedTypes.length);
            return SchemaException.buildMessage(pointer, actualTypeDescr, Arrays.asList(allExpecteds));
        }
        return String.format("%s: expected type: %s, found: %s", pointer, expectedType.getSimpleName(), actualTypeDescr);
    }

    private static String actualTypeDescr(Class<?> actualType) {
        return actualType == null ? "null" : actualType.getSimpleName();
    }

    static String buildMessage(String formattedPointer, String actualTypeDescr, Collection<Class<?>> expectedTypes) {
        String fmtExpectedTypes = expectedTypes.stream().map(Class::getSimpleName).collect(Collectors.joining(" or "));
        return String.format("%s: expected type is one of %s, found: %s", formattedPointer, fmtExpectedTypes, actualTypeDescr);
    }

    private static String buildMessage(String pointer, Class<?> actualType, Collection<Class<?>> expectedTypes) {
        return SchemaException.buildMessage(pointer, SchemaException.actualTypeDescr(actualType), expectedTypes);
    }

    private static String joinClassNames(List<Class<?>> expectedTypes) {
        return expectedTypes.stream().map(Class::getSimpleName).collect(Collectors.joining(", "));
    }

    public SchemaException(String schemaLocation, String message) {
        super(schemaLocation == null ? "<unknown location>: " + message : schemaLocation + ": " + message);
        this.schemaLocation = schemaLocation;
    }

    public SchemaException(String schemaLocation, Class<?> actualType, Class<?> expectedType, Class<?> ... furtherExpectedTypes) {
        super(SchemaException.buildMessage(schemaLocation, actualType, expectedType, furtherExpectedTypes));
        this.schemaLocation = schemaLocation;
    }

    public SchemaException(String schemaLocation, Class<?> actualType, Collection<Class<?>> expectedTypes) {
        super(SchemaException.buildMessage(schemaLocation, actualType, expectedTypes));
        this.schemaLocation = schemaLocation;
    }

    @Deprecated
    public SchemaException(String message) {
        this((String)null, message);
    }

    @Deprecated
    public SchemaException(String key, Class<?> expectedType, Object actualValue) {
        this(String.format("key %s : expected type: %s , found : %s", key, expectedType.getSimpleName(), SchemaException.typeOfValue(actualValue)));
    }

    @Deprecated
    public SchemaException(String key, List<Class<?>> expectedTypes, Object actualValue) {
        this(String.format("key %s: expected type is one of %s, found: %s", key, SchemaException.joinClassNames(expectedTypes), SchemaException.typeOfValue(actualValue)));
    }

    @Deprecated
    public SchemaException(String message, Throwable cause) {
        super(message, cause);
        this.schemaLocation = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaException that = (SchemaException)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }
}

