# nf-core/mag: Output

This document describes the output produced by the pipeline. Most of the plots are taken from the MultiQC report, which summarises results at the end of the pipeline.

## Pipeline overview

The pipeline is built using [Nextflow](https://www.nextflow.io/)
and processes data using the following steps:

- [Quality trimming and QC](#quality-trimming-and-qc) of input reads
- [Taxonomic classification](#taxonomic-classification) of trimmed reads
- [Assembly](#assembly) of trimmed reads
- [Binning](#binning) of assembled contigs
- [MultiQC](#multiqc) - aggregate report, describing results of the whole pipeline

## Quality trimming and QC

These steps trim away the adapter sequences present in input reads, trims away bad quality bases and sicard reads that are too short.
It also removes sequencing controls, such as PhiX or the Lambda phage, as well as runs FastQC for visualising the general quality metrics of the sequencing runs before and after trimming.

### FastQC

[FastQC](http://www.bioinformatics.babraham.ac.uk/projects/fastqc/) gives general quality metrics about your reads. It provides information about the quality score distribution across your reads, the per base sequence content (%T/A/G/C). You get information about adapter contamination and other overrepresented sequences.

For further reading and documentation see the [FastQC help](http://www.bioinformatics.babraham.ac.uk/projects/fastqc/Help/).

> **NB:** The FastQC plots displayed in the MultiQC report shows both _untrimmed_ and _trimmed_ reads.

**Output directory: `results/QC_shortreads/fastqc`**

- `sample_fastqc.html`
  - FastQC report, containing quality metrics for your untrimmed raw fastq files

### fastp

[fastp](https://github.com/OpenGene/fastp) is a all-in-one fastq preprocessor for read/adapter trimming and quality control. It is used in this pipeline for trimming adapter sequences and discard low-quality reads.

**Output directory: `results/QC_shortreads/fastp`**

- The trimmed reads are not included in the output by default, but the `--keep_trimmed` will store the trimmed reads in this directory

### remove_phix

The pipeline uses bowtie2 to map the reads against PhiX and removes mapped reads.

**Output directory: `results/QC_shortreads/remove_phix`**

- Contains a brief log file indicating how many reads have been removed.

### keep_lambda

The pipeline uses Nanolyse to map the reads against the Lambda phage and removes mapped reads.

**Output directory: `results/QC_longreads/NanoLyse`**

- Contains a brief log file indicating how many reads have been removed.

### Filtlong and porechop

The pipeline uses filtlong and porechop to perform quality control of the long reads that are eventually provided with the `--manifest` option.

**Output directory: `results/QC_longreads/NanoPlot_${sample_name}`**

- Contains various metrics and plots about the quality and length distribution of long reads, as well as an html report generated by nanoplot

For more information about Nanoplot see the [online documentation](https://github.com/wdecoster/NanoPlot)

## Taxonomic Classification

### Kraken

Kraken2 classifies reads using a k-mer based approach as well as assigns taxonomy using a Lowest Common Ancestor (LCA) algorithm.

**Output directory: `results/Taxonomy/kraken2/${sample_name}`**

- `*_kraken2.report`: Classification in the Kraken report format. See the [kraken manual](http://ccb.jhu.edu/software/kraken/MANUAL.html#sample-reports) for more details
- `taxonomy.krona.html`: an interactive pie chart produced by [KronaTools](https://github.com/marbl/Krona/wiki)

### Centrifuge

Centrifuge is commonly used for the classification of DNA sequences from microbial samples. It uses an indexing scheme based on the Burrows-Wheeler transform (BWT) and the Ferragina-Manzini (FM) index.

More information on the [Centrifuge](https://ccb.jhu.edu/software/centrifuge/) website

**Output directory: `results/Taxonomy/centrifuge/${sample_name}`**

- `report.txt`: Tab-delimited result file. See the [centrifuge manual](https://ccb.jhu.edu/software/centrifuge/manual.shtml#centrifuge-classification-output) for information about the fields
- `kreport.txt`: Classification in the Kraken report format. See the [kraken manual](http://ccb.jhu.edu/software/kraken/MANUAL.html#sample-reports) for more details
- `taxonomy.krona.html`: an interactive pie chart produced by [KronaTools](https://github.com/marbl/Krona/wiki)

### CAT

[CAT](https://github.com/dutilh/CAT) is a toolkit for annotating contigs and bins from metagenome-assembled-genomes. The MAG pipeline uses CAT to assign taxonomy to the contigs from megahit and/or SPAdes, and to assign taxonomy to genome bins based on the taxnomy of the contigs

**Output directory: `results/Taxonomy/${assembler}`**

- `*.ORF2LCA.txt`: Tab-delimited files containing the lineage of each contig
- `*.names.txt`: Taxonomy classification, with names of each lineage levels instead og taxids.
- `*.predicted_proteins.faa`: predicted protein sequences for each genome bins, in fasta format
- `*.predicted_proteins.gff`: predicted protein features for each genome bins, in gff format
- `*.log`: log files.
- `*.bin2classification.txt`: Taxonomy classification of the genome bins.

## Assembly

Trimmed (short) reads are assembled with both megahit and SPAdes. Hybrid assembly is only supported by SPAdes.

### Megahit

[megahit](https://github.com/voutcn/megahit) is a single node assembler for large and complex metagenomics short reads.

**Output directory: `results/MEGAHIT`**

- `${sample}.contigs.fasta`: metagenome assembly in fasta format
- `${sample}_QC/`: directory containing QUAST files

### SPAdes

[SPAdes](http://cab.spbu.ru/software/spades/) was originally a single genome assembler that later added support for assembling metagenomes.

**Output directory: `results/SPAdes`**

- `${sample}_contigs.fasta`: metagenome assembly in fasta format
- `${sample}_QC/`: directory containing QUAST files

### SPAdesHybrid

SPAdesHybrid is a part of the SPAdes software and is used when the user provides both long and short reads.

**Output directory: `results/SPAdesHybrid`**

- `${sample}_contigs.fasta`: metagenome assembly in fasta format
- `${sample}_QC/`: directory containing QUAST files

### Quast

[quast](http://cab.spbu.ru/software/quast/) is a tool that evaluates genome and metagenome assemblies by computing various metrics

**output directory:** `None`

- The quast output is included in the multiqc report, as well as in the assembly directories themselves

## Binning

### Metabat

[metabat](https://bitbucket.org/berkeleylab/metabat) recovers genome bins (that is, contigs/scaffolds that all belongs to a same organism) from metagenome assemblies. Additionally, Quast is run again on all the genome bins.

**output directory: `results/GenomeBinning/MetaBat2`**

- `*.fa`: Genome bins retrieved from the different input assemblies

### Busco

Busco is a tool used to assess the completeness of a genome assembly. It is run on all the genome bins obtained by metabat2

**output directory: `results/GenomeBinning/QC/`**

- `busco_summary.txt`: A summary tabke of the BUSCO results, with % of marker genes found

## MultiQC

[MultiQC](http://multiqc.info) is a visualisation tool that generates a single HTML report summarising all samples in your project. Most of the pipeline QC results are visualised in the report and further statistics are available in within the report data directory.

The pipeline has special steps which allow the software versions used to be reported in the MultiQC output for future traceability.

**Output directory: `results/multiqc`**

- `Project_multiqc_report.html`
  - MultiQC report - a standalone HTML file that can be viewed in your web browser
- `Project_multiqc_data/`
  - Directory containing parsed statistics from the different tools used in the pipeline

For more information about how to use MultiQC reports, see <http://multiqc.info>
