#!/usr/bin/env nextflow
/*
========================================================================================
    nf-core/mag
========================================================================================
    Github : https://github.com/nf-core/mag
    Website: https://nf-co.re/mag
    Slack  : https://nfcore.slack.com/channels/mag
----------------------------------------------------------------------------------------
*/

nextflow.enable.dsl = 2

/*
========================================================================================
    VALIDATE & PRINT PARAMETER SUMMARY
========================================================================================
*/

WorkflowMain.initialise(workflow, params, log)

/*
========================================================================================
    NAMED WORKFLOW FOR PIPELINE
========================================================================================
*/

include { MAG } from './workflows/mag'

//
// WORKFLOW: Run main nf-core/mag analysis pipeline
//
workflow NFCORE_MAG {
    MAG ()
}

/*
========================================================================================
    RUN ALL WORKFLOWS
========================================================================================
*/

//
// WORKFLOW: Execute a single named workflow for the pipeline
// See: https://github.com/nf-core/rnaseq/issues/619
//
workflow {
    NFCORE_MAG ()
}

/*
========================================================================================
    THE END
========================================================================================
*/
