---
name: Bug report
about: Report something that is broken or incorrect
labels: bug
---

<!--
# nf-core/marsseq bug report

Hi there!

Thanks for telling us about a problem with the pipeline.
Please delete this text and anything that's not relevant from the template below:
-->

## Check Documentation

I have checked the following places for your error:

- [ ] [nf-core website: troubleshooting](https://nf-co.re/usage/troubleshooting)
- [ ] [nf-core/marsseq pipeline documentation](https://nf-co.re/marsseq/usage)

## Description of the bug

<!-- A clear and concise description of what the bug is. -->

## Steps to reproduce

Steps to reproduce the behaviour:

1. Command line: <!-- [e.g. `nextflow run ...`] -->
2. See error: <!-- [Please provide your error message] -->

## Expected behaviour

<!-- A clear and concise description of what you expected to happen. -->

## Log files

Have you provided the following extra information/files:

- [ ] The command used to run the pipeline
- [ ] The `.nextflow.log` file <!-- this is a hidden file in the directory where you launched the pipeline -->

## System

- Hardware: <!-- [e.g. HPC, Desktop, Cloud...] -->
- Executor: <!-- [e.g. slurm, local, awsbatch...] -->
- OS: <!-- [e.g. CentOS Linux, macOS, Linux Mint...] -->
- Version <!-- [e.g. 7, 10.13.6, 18.3...] -->

## Nextflow Installation

- Version: <!-- [e.g. 21.04.0] -->

## Container engine

- Engine: <!-- [e.g. Conda, Docker, Singularity, Podman, Shifter or Charliecloud] -->
- version: <!-- [e.g. 1.0.0] -->

## Additional context

<!-- Add any other context about the problem here. -->
