# nf-core/metatdenovo: Citations

## [nf-core](https://pubmed.ncbi.nlm.nih.gov/32055031/)

> Ewels PA, Peltzer A, Fillinger S, Patel H, Alneberg J, Wilm A, Garcia MU, Di Tommaso P, Nahnsen S. The nf-core framework for community-curated bioinformatics pipelines. Nat Biotechnol. 2020 Mar;38(3):276-278. doi: 10.1038/s41587-020-0439-x. PubMed PMID: 32055031.

## [Nextflow](https://pubmed.ncbi.nlm.nih.gov/28398311/)

> Di Tommaso P, Chatzou M, Floden EW, Barja PP, Palumbo E, Notredame C. Nextflow enables reproducible computational workflows. Nat Biotechnol. 2017 Apr 11;35(4):316-319. doi: 10.1038/nbt.3820. PubMed PMID: 28398311.

## Pipeline tools

- [FastQC](https://www.bioinformatics.babraham.ac.uk/projects/fastqc/)

> Andrews, S. (2010). FastQC: A Quality Control Tool for High Throughput Sequence Data [Online].

- [MultiQC](https://pubmed.ncbi.nlm.nih.gov/27312411/)

> Ewels P, Magnusson M, Lundin S, Käller M. MultiQC: summarize analysis results for multiple tools and samples in a single report. Bioinformatics. 2016 Oct 1;32(19):3047-8. doi: 10.1093/bioinformatics/btw354. Epub 2016 Jun 16. PubMed PMID: 27312411; PubMed Central PMCID: PMC5039924.

- [Trim Galore!](https://www.bioinformatics.babraham.ac.uk/projects/trim_galore/)

- [khmer](https://github.com/dib-lab/khmer)

  > Brown C, Howe A, Zhang Q, Pyrkosz , and Brom T. 2012. “A Reference-Free Algorithm for Computational Normalization of Shotgun Sequencing Data.” ArXiv:1203.4802 [q-Bio], May. arxiv.org/abs/1203.4802.
  > Crusoe M, Alameldin H, Awad S, Boucher E, Caldwell A, Cartwright R, Charbonneau A, et al. 2015. “The Khmer Software Package: Enabling Efficient Nucleotide Sequence Analysis.” F1000Research 4 (September): 900. doi.org/10.12688/f1000research.6924.1.
  > Qingpeng Z, Pell J, Canino-Koning R, Howe A, and Brown C. 2014. “These Are Not the K-Mers You Are Looking For: Efficient Online K-Mer Counting Using a Probabilistic Data Structure.” PLOS ONE 9 (7): e101271. doi.org/10.1371/journal.pone.0101271.

- [Seqtk](https://github.com/lh3/seqtk)

- [RNAspade](https://cab.spbu.ru/software/rnaspades/)

  > Bankevich A, Nurk S, Antipov D, Gurevich AA, Dvorkin M, Kulikov AS, Lesin VM, Nikolenko SI, Pham S, Prjibelski AD, Pyshkin AV, Sirotkin AV, Vyahhi N, Tesler G, Alekseyev MA, Pevzner PA. SPAdes: a new genome assembly algorithm and its applications to single-cell sequencing. J Comput Biol. 2012 May;19(5):455-77. doi: 10.1089/cmb.2012.0021.
  > Nurk S, Meleshko D, Korobeynikov A, Pevzner PA. metaSPAdes: a new versatile metagenomic assembler. Genome Res. 2017 May;27(5):824-834. doi: 10.1101/gr.213959.116. Epub 2017 Mar 15.
  > Bushmanova E, Antipov D, Lapidus A, Prjibelski A, rnaSPAdes: a de novo transcriptome assembler and its application to RNA-Seq data GigaScience, 2019
  > Prjibelski, A., Antipov, D., Meleshko, D., Lapidus, A., & Korobeynikov, A. (2020). “Using SPAdes de novo assembler.” Current Protocols in Bioinformatics, 70, e102. doi: 10.1002/cpbi.102
  > Antipov D, Raiko M, Lapidus A, Pevzner P, METAVIRALSPADES: assembly of viruses from metagenomic data, Bioinformatics, Volume 36, Issue 14, July 2020, Pages 4126–4129, https://doi.org/10.1093/bioinformatics/btaa490

- [Megahit](https://github.com/voutcn/megahit)

  > Li D, Liu C, Luo R, Sadakane K, and Lam T, (2015) MEGAHIT: An ultra-fast single-node solution for large and complex metagenomics assembly via succinct de Bruijn graph. Bioinformatics, doi: 10.1093/bioinformatics/btv033 [PMID: 25609793].
  > Li D, Luo R, Liu C, Leung C, Ting H, Sadakane K, Yamashita H and Lam T, 2016. MEGAHIT v1.0: A Fast and Scalable Metagenome Assembler driven by Advanced Methodologies and Community Practices. Methods.

- [TransDecoder](https://github.com/TransDecoder/TransDecoder)

- [Prokka](https://github.com/tseemann/prokka)

  > Seemann T Prokka: rapid prokaryotic genome annotation Bioinformatics 2014 Jul 15;30(14):2068-9. PMID:24642063

- [Prodigal](https://github.com/hyattpd/Prodigal)

- [BBmap](https://sourceforge.net/projects/bbmap/)

- [FeatureCounts](https://subread.sourceforge.net)

  > Liao Y, Smyth GK and Shi W. The R package Rsubread is easier, faster, cheaper and better for alignment and quantification of RNA sequencing reads. Nucleic Acids Research, 47(8):e47, 2019
  > Liao Y, Smyth GK and Shi W. featureCounts: an efficient general-purpose program for assigning sequence reads to genomic features. Bioinformatics, 30(7):923-30, 2014
  > Liao Y, Smyth GK and Shi W. The Subread aligner: fast, accurate and scalable read mapping by seed-and-vote. Nucleic Acids Research, 41(10):e108, 2013

- [Eggnog](https://github.com/eggnogdb/eggnog-mapper)

  > Cantalapiedra C, Hernandez-Plaza A, Letunic I, Bork P, Huerta-Cepas J.
  > eggNOG-mapper v2: functional annotation, orthology assignments, and domain
  > prediction at the metagenomic scale 2021.
  > Molecular Biology and Evolution, msab293, https://doi.org/10.1093/molbev/msab293
  > eggNOG 5.0: a hierarchical, functionally and phylogenetically annotated
  > orthology resource based on 5090 organisms and 2502 viruses. Jaime
  > Huerta-Cepas, Damian Szklarczyk, Davide Heller, Ana Hernández-Plaza, Sofia
  > K Forslund, Helen Cook, Daniel R Mende, Ivica Letunic, Thomas Rattei, Lars
  > J Jensen, Christian von Mering, Peer Bork Nucleic Acids Res. 2019 Jan 8;
  > 47(Database issue): D309–D314. doi: 10.1093/nar/gky1085

- [Kofamscan](https://github.com/takaram/kofam_scan)

- [HMMsearch](https://www.ebi.ac.uk/Tools/hmmer/search/hmmsearch)

- [EUKulele](https://github.com/AlexanderLabWHOI/EUKulele)

- [Diamond](https://github.com/bbuchfink/diamond)

  > Buchfink B, Xie C, and Huson D. 2015. “Fast and Sensitive Protein Alignment Using DIAMOND.” Nature Methods 12 (1): 59–60. https://doi.org/10.1038/nmeth.3176.

- [TaxonKit](https://bioinf.shenwei.me/taxonkit/)

  > Wei S, Ren H. 2021. “TaxonKit: A Practical and Efficient NCBI Taxonomy Toolkit.” Journal of Genetics and Genomics, Special issue on Microbiome, 48 (9): 844–50. https://doi.org/10.1016/j.jgg.2021.03.006.

- [CAT](https://github.com/dutilh/CAT)

  > von Meijenfeldt FAB, Arkhipova K, Cambuy DD, Coutinho FH, Dutilh BE. Robust taxonomic classification of uncharted microbial sequences and bins with CAT and BAT. Genome Biology. 2019;20:217.

- [transrate](https://hibberdlab.com/transrate/)

  > Smith-Unna R, Boursnell C, Patro R, Hibberd J, Kelly S. TransRate: reference free quality assessment of de-novo transcriptome assemblies (2016). Genome Research doi: [http://dx.doi.org/10.1101/gr.196469.115](http://dx.doi.org/10.1101/gr.196469.115)

## Software packaging/containerisation tools

- [Anaconda](https://anaconda.com)

  > Anaconda Software Distribution. Computer software. Vers. 2-2.4.0. Anaconda, Nov. 2016. Web.

- [Bioconda](https://pubmed.ncbi.nlm.nih.gov/29967506/)

  > Grüning B, Dale R, Sjödin A, Chapman BA, Rowe J, Tomkins-Tinch CH, Valieris R, Köster J; Bioconda Team. Bioconda: sustainable and comprehensive software distribution for the life sciences. Nat Methods. 2018 Jul;15(7):475-476. doi: 10.1038/s41592-018-0046-7. PubMed PMID: 29967506.

- [BioContainers](https://pubmed.ncbi.nlm.nih.gov/28379341/)

  > da Veiga Leprevost F, Grüning B, Aflitos SA, Röst HL, Uszkoreit J, Barsnes H, Vaudel M, Moreno P, Gatto L, Weber J, Bai M, Jimenez RC, Sachsenberg T, Pfeuffer J, Alvarez RV, Griss J, Nesvizhskii AI, Perez-Riverol Y. BioContainers: an open-source and community-driven framework for software standardization. Bioinformatics. 2017 Aug 15;33(16):2580-2582. doi: 10.1093/bioinformatics/btx192. PubMed PMID: 28379341; PubMed Central PMCID: PMC5870671.

- [Docker](https://dl.acm.org/doi/10.5555/2600239.2600241)

  > Merkel, D. (2014). Docker: lightweight linux containers for consistent development and deployment. Linux Journal, 2014(239), 2. doi: 10.5555/2600239.2600241.

- [Singularity](https://pubmed.ncbi.nlm.nih.gov/28494014/)

  > Kurtzer GM, Sochat V, Bauer MW. Singularity: Scientific containers for mobility of compute. PLoS One. 2017 May 11;12(5):e0177459. doi: 10.1371/journal.pone.0177459. eCollection 2017. PubMed PMID: 28494014; PubMed Central PMCID: PMC5426675.
